/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class InputStreamEntityWriter
implements EntityWriter<InputStream> {
    public static final int DEFAULT_CHUNK_SIZE = 1024;

    @Override
    public Class<InputStream> getType() {
        return InputStream.class;
    }

    @Override
    public void writeData(HTTPCarbonMessage carbonMessage, InputStream ipStream, String mediaType, int chunkSize, HTTPCarbonMessage responder) {
        try {
            int len;
            if (chunkSize == 0 || chunkSize == -1) {
                chunkSize = 1024;
            }
            carbonMessage.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
            carbonMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType);
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    responder.respond(carbonMessage);
                }
                catch (ServerConnectorException e) {
                    throw new RuntimeException("Error while sending the response.", e);
                }
            });
            byte[] data = new byte[chunkSize];
            while ((len = ipStream.read(data)) != -1) {
                carbonMessage.addHttpContent(new DefaultHttpContent(Unpooled.wrappedBuffer(ByteBuffer.wrap(data, 0, len))));
                data = new byte[chunkSize];
            }
            carbonMessage.addHttpContent(new DefaultLastHttpContent());
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while reading from InputStream", e);
        }
        finally {
            if (ipStream != null) {
                try {
                    ipStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

