/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.ByteBuffer;
import org.wso2.msf4j.internal.beanconversion.BeanConverter;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class ObjectEntityWriter
implements EntityWriter<Object> {
    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void writeData(HTTPCarbonMessage carbonMessage, Object entity, String mediaType, int chunkSize, HTTPCarbonMessage responder) {
        mediaType = mediaType != null ? mediaType : "*/*";
        ByteBuffer byteBuffer = BeanConverter.getConverter(mediaType).convertToMedia(entity);
        carbonMessage.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(byteBuffer)));
        if (chunkSize == 0) {
            carbonMessage.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(byteBuffer.remaining()));
        } else {
            carbonMessage.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
        }
        carbonMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType);
        try {
            responder.respond(carbonMessage);
        }
        catch (ServerConnectorException e) {
            throw new RuntimeException("Error while sending the response.", e);
        }
    }
}

