/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class ObjectToObjectConverter
implements ConditionalGenericConverter {
    ObjectToObjectConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType().equals(targetType.getType())) {
            return false;
        }
        return String.class == targetType.getType() ? ObjectToObjectConverter.hasFactoryConstructor(String.class, sourceType.getType()) : ObjectToObjectConverter.hasToMethodOrFactoryMethodOrConstructor(targetType.getType(), sourceType.getType());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = sourceType.getType();
        Class<?> targetClass = targetType.getType();
        try {
            Method method;
            if (String.class != targetClass && (method = ObjectToObjectConverter.getToMethod(targetClass, sourceClass)) != null) {
                ReflectionUtils.makeAccessible(method);
                return method.invoke(source, new Object[0]);
            }
            method = ObjectToObjectConverter.getFactoryMethod(targetClass, sourceClass);
            if (method != null) {
                ReflectionUtils.makeAccessible(method);
                return method.invoke(null, source);
            }
            Constructor<?> constructor = ObjectToObjectConverter.getFactoryConstructor(targetClass, sourceClass);
            if (constructor != null) {
                return constructor.newInstance(source);
            }
        }
        catch (InvocationTargetException ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
        String message = String.format("No to%3$s() method exists on %1$s, and no static valueOf/of/from(%1$s) method or %3$s(%1$s) constructor exists on %2$s.", sourceClass.getName(), targetClass.getName(), targetClass.getSimpleName());
        throw new IllegalStateException(message);
    }

    private static Method getToMethod(Class<?> targetClass, Class<?> sourceClass) {
        Method method = ClassUtils.getMethodIfAvailable(sourceClass, "to" + targetClass.getSimpleName(), new Class[0]);
        return method != null && targetClass.equals(method.getReturnType()) ? method : null;
    }

    private static Method getFactoryMethod(Class<?> targetClass, Class<?> sourceClass) {
        Method method = ClassUtils.getStaticMethod(targetClass, "valueOf", sourceClass);
        if (method == null && (method = ClassUtils.getStaticMethod(targetClass, "of", sourceClass)) == null) {
            method = ClassUtils.getStaticMethod(targetClass, "from", sourceClass);
        }
        return method;
    }

    private static Constructor<?> getFactoryConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ClassUtils.getConstructorIfAvailable(targetClass, sourceClass);
    }

    private static boolean hasToMethodOrFactoryMethodOrConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.hasToMethod(targetClass, sourceClass) || ObjectToObjectConverter.hasFactoryMethod(targetClass, sourceClass) || ObjectToObjectConverter.hasFactoryConstructor(targetClass, sourceClass);
    }

    static boolean hasToMethod(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getToMethod(targetClass, sourceClass) != null;
    }

    static boolean hasFactoryMethod(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getFactoryMethod(targetClass, sourceClass) != null;
    }

    static boolean hasFactoryConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getFactoryConstructor(targetClass, sourceClass) != null;
    }
}

