/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.Constants;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.ResponseCompleted;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private final HandlerExecutor handlerExecutor;
    private final HttpResponseFuture outboundRespStatusFuture;
    private final MessageStateContext messageStateContext;
    private boolean headersWritten;
    private long contentLength = 0L;
    private boolean headRequest;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();
    private HttpCarbonMessage inboundRequestMsg;
    private ChannelHandlerContext sourceContext;
    private SourceHandler sourceHandler;

    SendingEntityBody(MessageStateContext messageStateContext, HttpResponseFuture outboundRespStatusFuture, boolean headersWritten) {
        this.messageStateContext = messageStateContext;
        this.outboundRespStatusFuture = outboundRespStatusFuture;
        this.headersWritten = headersWritten;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        this.headRequest = outboundRespListener.getRequestDataHolder().getHttpMethod().equalsIgnoreCase("HEAD");
        this.inboundRequestMsg = outboundRespListener.getInboundRequestMsg();
        this.sourceContext = outboundRespListener.getSourceContext();
        this.sourceHandler = outboundRespListener.getSourceHandler();
        if (httpContent instanceof LastHttpContent) {
            ChannelFuture outboundChannelFuture;
            if (this.headersWritten) {
                outboundChannelFuture = this.checkHeadRequestAndWriteOutboundResponseBody(httpContent);
            } else {
                this.contentLength += (long)httpContent.content().readableBytes();
                Util.setupContentLengthRequest(outboundResponseMsg, this.contentLength);
                outboundChannelFuture = this.writeOutboundResponseHeaderAndBody(outboundRespListener, outboundResponseMsg, (LastHttpContent)httpContent);
            }
            if (!outboundRespListener.isKeepAlive()) {
                outboundChannelFuture.addListener(ChannelFutureListener.CLOSE);
            } else {
                this.triggerPipeliningLogic(outboundResponseMsg);
            }
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceResponseSending(outboundResponseMsg);
            }
        } else if (this.headersWritten) {
            if (this.headRequest) {
                httpContent.release();
                return;
            }
            outboundRespListener.getSourceContext().writeAndFlush(httpContent);
        } else {
            this.contentList.add(httpContent);
            this.contentLength += (long)httpContent.content().readableBytes();
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.error("Remote client closed the connection while writing outbound response entity body");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.error("Idle timeout triggered while writing outbound response entity body");
        return null;
    }

    private ChannelFuture checkHeadRequestAndWriteOutboundResponseBody(HttpContent httpContent) {
        ChannelFuture outboundChannelFuture;
        if (this.headRequest) {
            httpContent.release();
            outboundChannelFuture = this.writeOutboundResponseBody(new DefaultLastHttpContent());
        } else {
            outboundChannelFuture = this.writeOutboundResponseBody(httpContent);
        }
        return outboundChannelFuture;
    }

    private ChannelFuture writeOutboundResponseHeaderAndBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, LastHttpContent lastHttpContent) {
        CompositeByteBuf allContent = Unpooled.compositeBuffer();
        for (HttpContent cachedHttpContent : this.contentList) {
            allContent.addComponent(true, cachedHttpContent.content());
        }
        allContent.addComponent(true, lastHttpContent.content());
        if (this.headRequest) {
            allContent.release();
            allContent = Unpooled.compositeBuffer();
            allContent.addComponent(true, new DefaultLastHttpContent().content());
        }
        HttpResponse fullOutboundResponse = Util.createFullHttpResponse(outboundResponseMsg, outboundRespListener.getRequestDataHolder().getHttpVersion(), outboundRespListener.getServerName(), outboundRespListener.isKeepAlive(), allContent);
        ChannelFuture outboundChannelFuture = this.sourceContext.writeAndFlush(fullOutboundResponse);
        this.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, outboundChannelFuture);
        return outboundChannelFuture;
    }

    private ChannelFuture writeOutboundResponseBody(HttpContent lastHttpContent) {
        ChannelFuture outboundChannelFuture = this.sourceContext.writeAndFlush(lastHttpContent);
        this.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, outboundChannelFuture);
        return outboundChannelFuture;
    }

    private void checkForResponseWriteStatus(HttpCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Connection between remote client and host is closed");
                }
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(inboundRequestMsg);
            }
            this.messageStateContext.setListenerState(new ResponseCompleted(this.sourceHandler, this.messageStateContext, inboundRequestMsg));
            this.resetOutboundListenerState();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerPipeliningLogic(HttpCarbonMessage outboundResponseMsg) {
        String httpVersion = (String)this.inboundRequestMsg.getProperty("HTTP_VERSION");
        if (outboundResponseMsg.isPipeliningEnabled() && "1.1".equalsIgnoreCase(httpVersion)) {
            Queue responseQueue;
            Queue queue = this.sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
            synchronized (queue) {
                Long nextSequenceNumber;
                responseQueue = this.sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
                Long l = nextSequenceNumber = this.sourceContext.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).get();
                Long l2 = nextSequenceNumber = Long.valueOf(nextSequenceNumber + 1L);
                this.sourceContext.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).set(nextSequenceNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current sequence id of the response : {}", (Object)outboundResponseMsg.getSequenceId());
                    LOG.debug("Updated next sequence id to : {}", (Object)nextSequenceNumber);
                }
            }
            if (!responseQueue.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pipelining logic is triggered from transport");
                }
                if (outboundResponseMsg.getPipeliningFuture() != null) {
                    EventExecutorGroup pipeliningExecutor = this.sourceContext.channel().attr(Constants.PIPELINING_EXECUTOR).get();
                    pipeliningExecutor.execute(() -> outboundResponseMsg.getPipeliningFuture().notifyPipeliningListener(this.sourceContext));
                }
            }
        }
    }

    private void resetOutboundListenerState() {
        this.contentList.clear();
        this.contentLength = 0L;
        this.headersWritten = false;
    }
}

