/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ResponseCompleted;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private static final InternalLogger ACCESS_LOGGER = InternalLoggerFactory.getInstance("http.accesslog");
    private final Http2MessageStateContext http2MessageStateContext;
    private final ChannelHandlerContext ctx;
    private final HttpServerChannelInitializer serverChannelInitializer;
    private final Http2Connection conn;
    private final Http2ConnectionEncoder encoder;
    private final HttpResponseFuture outboundRespStatusFuture;
    private final HttpCarbonMessage inboundRequestMsg;
    private final Calendar inboundRequestArrivalTime;
    private final int originalStreamId;
    private Long contentLength = 0L;
    private String remoteAddress;

    SendingEntityBody(Http2OutboundRespListener http2OutboundRespListener, Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
        this.ctx = http2OutboundRespListener.getChannelHandlerContext();
        this.serverChannelInitializer = http2OutboundRespListener.getServerChannelInitializer();
        this.conn = http2OutboundRespListener.getConnection();
        this.encoder = http2OutboundRespListener.getEncoder();
        this.inboundRequestMsg = http2OutboundRespListener.getInboundRequestMsg();
        this.outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
        this.inboundRequestArrivalTime = http2OutboundRespListener.getInboundRequestArrivalTime();
        this.originalStreamId = http2OutboundRespListener.getOriginalStreamId();
        this.remoteAddress = http2OutboundRespListener.getRemoteAddress();
    }

    @Override
    public void readInboundRequestHeaders(Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) throws Http2Exception {
        this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext, Boolean.TRUE));
        this.http2MessageStateContext.getListenerState().readInboundRequestBody(http2SourceHandler, dataFrame);
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        this.writeContent(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        LOG.warn("writeOutboundPromise is not a dependant action of this state");
        throw new Http2Exception(Http2Error.PROTOCOL_ERROR, "WriteOutboundPromise is not a dependant action of SendingEntityBody state");
    }

    private void writeContent(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (httpContent instanceof LastHttpContent) {
            LastHttpContent lastContent = (LastHttpContent)httpContent;
            HttpHeaders trailers = lastContent.trailingHeaders();
            if (this.serverChannelInitializer.isHttpAccessLogEnabled()) {
                this.logAccessInfo(outboundResponseMsg, streamId);
            }
            boolean endStream = trailers.isEmpty();
            this.writeData(lastContent, streamId, endStream);
            if (!trailers.isEmpty()) {
                Http2Headers http2Trailers = HttpConversionUtil.toHttp2Headers(trailers, true);
                Http2StateUtil.writeHttp2Headers(this.ctx, this.encoder, this.outboundRespStatusFuture, streamId, http2Trailers, true);
            }
            this.http2MessageStateContext.setListenerState(new ResponseCompleted(http2OutboundRespListener, this.http2MessageStateContext));
        } else {
            this.writeData(httpContent, streamId, false);
        }
    }

    private void writeData(HttpContent httpContent, int streamId, boolean endStream) throws Http2Exception {
        this.contentLength = this.contentLength + (long)httpContent.content().readableBytes();
        Http2StateUtil.validatePromisedStreamState(this.originalStreamId, streamId, this.conn, this.inboundRequestMsg);
        ChannelFuture channelFuture = this.encoder.writeData(this.ctx, streamId, httpContent.content(), 0, endStream, this.ctx.newPromise());
        this.encoder.flowController().writePendingBytes();
        this.ctx.flush();
        if (endStream) {
            Util.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, channelFuture);
        } else {
            Util.addResponseWriteFailureListener(this.outboundRespStatusFuture, channelFuture);
        }
    }

    private void logAccessInfo(HttpCarbonMessage outboundResponseMsg, int streamId) {
        if (!ACCESS_LOGGER.isEnabled(InternalLogLevel.INFO)) {
            return;
        }
        if (this.originalStreamId != streamId) {
            LOG.debug("Access logging skipped for server push response");
            return;
        }
        HttpHeaders headers = this.inboundRequestMsg.getHeaders();
        if (headers.contains("x-forwarded-for")) {
            String forwardedHops = headers.get("x-forwarded-for");
            int firstCommaIndex = forwardedHops.indexOf(44);
            this.remoteAddress = firstCommaIndex != -1 ? forwardedHops.substring(0, firstCommaIndex) : forwardedHops;
        }
        String userAgent = "-";
        if (headers.contains(HttpHeaderNames.USER_AGENT)) {
            userAgent = headers.get(HttpHeaderNames.USER_AGENT);
        }
        String referrer = "-";
        if (headers.contains(HttpHeaderNames.REFERER)) {
            referrer = headers.get(HttpHeaderNames.REFERER);
        }
        String method = (String)this.inboundRequestMsg.getProperty("HTTP_METHOD");
        String uri = (String)this.inboundRequestMsg.getProperty("TO");
        HttpRequest request = this.inboundRequestMsg.getNettyHttpRequest();
        String protocol = request != null ? request.protocolVersion().toString() : (String)this.inboundRequestMsg.getProperty("HTTP_VERSION");
        int statusCode = Util.getHttpResponseStatus(outboundResponseMsg).code();
        ACCESS_LOGGER.log(InternalLogLevel.INFO, String.format("%1$s - - [%2$td/%2$tb/%2$tY:%2$tT %2$tz] \"%3$s %4$s %5$s\" %6$d %7$d \"%8$s\" \"%9$s\"", this.remoteAddress, this.inboundRequestArrivalTime, method, uri, protocol, statusCode, this.contentLength, referrer, userAgent));
    }
}

