/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.EndpointTimeOutException;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;

public class TimeoutHandler
implements Http2DataEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private long idleTimeNanos;
    private Http2ClientChannel http2ClientChannel;
    private Map<Integer, ScheduledFuture<?>> timerTasks;

    public TimeoutHandler(long idleTimeMills, Http2ClientChannel http2ClientChannel) {
        this.idleTimeNanos = Math.max(TimeUnit.MILLISECONDS.toNanos(idleTimeMills), MIN_TIMEOUT_NANOS);
        this.http2ClientChannel = http2ClientChannel;
        this.timerTasks = new ConcurrentHashMap();
    }

    @Override
    public boolean onStreamInit(ChannelHandlerContext ctx, int streamId) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(this.ticksInNanos());
            this.timerTasks.put(streamId, this.schedule(ctx, new IdleTimeoutTask(ctx, streamId), this.idleTimeNanos));
        }
        return true;
    }

    @Override
    public boolean onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onPushPromiseRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onHeadersWrite(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public boolean onDataWrite(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public void onStreamReset(int streamId) {
        this.onStreamClose(streamId);
    }

    @Override
    public void onStreamClose(int streamId) {
        ScheduledFuture<?> timerTask = this.timerTasks.get(streamId);
        if (timerTask != null) {
            timerTask.cancel(false);
            this.timerTasks.remove(streamId);
        }
    }

    @Override
    public void destroy() {
        this.timerTasks.forEach((streamId, task) -> task.cancel(false));
        this.timerTasks.clear();
    }

    private void updateLastReadTime(int streamId, boolean endOfStream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(this.ticksInNanos());
        }
        if (endOfStream) {
            this.onStreamClose(streamId);
        }
    }

    private void updateLastWriteTime(int streamId) {
        OutboundMsgHolder msgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (msgHolder != null) {
            msgHolder.setLastReadWriteTime(this.ticksInNanos());
        } else {
            LOG.debug("OutboundMsgHolder may have already been removed for streamId: {}", (Object)streamId);
        }
    }

    private long ticksInNanos() {
        return System.nanoTime();
    }

    private ScheduledFuture<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay) {
        return ctx.executor().schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    private class IdleTimeoutTask
    implements Runnable {
        private ChannelHandlerContext ctx;
        private OutboundMsgHolder msgHolder;
        private int streamId;

        IdleTimeoutTask(ChannelHandlerContext ctx, int streamId) {
            this.ctx = ctx;
            this.streamId = streamId;
            this.msgHolder = TimeoutHandler.this.http2ClientChannel.getInFlightMessage(streamId);
        }

        @Override
        public void run() {
            long nextDelay = TimeoutHandler.this.idleTimeNanos - (TimeoutHandler.this.ticksInNanos() - this.msgHolder.getLastReadWriteTime());
            if (nextDelay <= 0L) {
                this.closeStream(this.streamId, this.ctx);
                if (this.msgHolder.getResponse() != null) {
                    this.handleIncompleteInboundResponse();
                } else if (this.msgHolder.isRequestWritten()) {
                    this.msgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered before initiating inbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
                } else {
                    this.msgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered before initiating outbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
                }
                TimeoutHandler.this.http2ClientChannel.removeInFlightMessage(this.streamId);
            } else {
                TimeoutHandler.this.timerTasks.put(this.streamId, TimeoutHandler.this.schedule(this.ctx, this, nextDelay));
            }
        }

        private void handleIncompleteInboundResponse() {
            DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
            lastHttpContent.setDecoderResult(DecoderResult.failure(new DecoderException("Idle timeout triggered while reading inbound response entity body")));
            this.msgHolder.getResponse().addHttpContent(lastHttpContent);
            LOG.warn("Idle timeout triggered while reading inbound response entity body");
        }

        private void closeStream(int streamId, ChannelHandlerContext ctx) {
            Http2TargetHandler clientOutboundHandler = (Http2TargetHandler)ctx.pipeline().get("http2TargetHandler");
            clientOutboundHandler.resetStream(ctx, streamId, Http2Error.STREAM_CLOSED);
        }
    }
}

