/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.states.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final MessageStateContext messageStateContext;
    private final TargetHandler targetHandler;

    ReceivingEntityBody(MessageStateContext messageStateContext, TargetHandler targetHandler) {
        this.messageStateContext = messageStateContext;
        this.targetHandler = targetHandler;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestEntity {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        LOG.warn("readInboundResponseHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        inboundResponseMsg.addHttpContent(httpContent);
        if (Util.isLastHttpContent(httpContent)) {
            inboundResponseMsg.setLastHttpContentArrived();
            this.targetHandler.resetInboundMsg();
            this.targetHandler.getTargetChannel().getChannel().pipeline().remove("idleStateHandler");
            this.messageStateContext.setSenderState(new EntityBodyReceived());
            if (!Util.isKeepAlive(this.targetHandler.getKeepAliveConfig(), this.targetHandler.getOutboundRequestMsg())) {
                this.targetHandler.closeChannel(ctx);
            }
            this.targetHandler.getConnectionManager().returnChannel(this.targetHandler.getTargetChannel());
        }
    }

    @Override
    public void handleAbruptChannelClosure(HttpResponseFuture httpResponseFuture) {
        StateUtil.handleIncompleteInboundMessage(this.targetHandler.getInboundResponseMsg(), "Remote host closed the connection while reading inbound response body");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(HttpResponseFuture httpResponseFuture, String channelID) {
        StateUtil.handleIncompleteInboundMessage(this.targetHandler.getInboundResponseMsg(), "Idle timeout triggered while reading inbound response entity body");
    }
}

