/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.RequestCompleted;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private final MessageStateContext messageStateContext;
    private final boolean headersWritten;
    private final HandlerExecutor handlerExecutor;
    private final TargetChannel targetChannel;
    private final HttpResponseFuture httpInboundResponseFuture;
    private final String httpVersion;
    private long contentLength = 0L;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();

    SendingEntityBody(MessageStateContext messageStateContext, TargetChannel targetChannel, boolean headersWritten, HttpResponseFuture httpInboundResponseFuture) {
        this.messageStateContext = messageStateContext;
        this.targetChannel = targetChannel;
        this.headersWritten = headersWritten;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.httpInboundResponseFuture = httpInboundResponseFuture;
        this.httpVersion = targetChannel.getHttpVersion();
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        if (Util.isLastHttpContent(httpContent)) {
            if (!this.headersWritten) {
                this.contentLength += (long)httpContent.content().readableBytes();
                Util.setupContentLengthRequest(httpOutboundRequest, this.contentLength);
                StateUtil.writeRequestHeaders(httpOutboundRequest, this.httpInboundResponseFuture, this.httpVersion, this.targetChannel);
                for (HttpContent cachedHttpContent : this.contentList) {
                    this.targetChannel.getChannel().writeAndFlush(cachedHttpContent);
                }
            }
            this.writeOutboundRequestBody(httpContent);
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtTargetRequestSending(httpOutboundRequest);
            }
        } else if (this.headersWritten) {
            this.targetChannel.getChannel().writeAndFlush(httpContent);
        } else {
            this.contentList.add(httpContent);
            this.contentLength += (long)httpContent.content().readableBytes();
        }
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        targetHandler.getOutboundRequestMsg().setIoException(new IOException("Inbound response message already received"));
        this.messageStateContext.setSenderState(new ReceivingHeaders(this.messageStateContext));
        this.messageStateContext.getSenderState().readInboundResponseHeaders(targetHandler, httpInboundResponse);
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) {
        LOG.warn("readInboundResponseEntityBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(HttpResponseFuture httpResponseFuture) {
        LOG.error("Remote host closed the connection while writing outbound request entity body");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(HttpResponseFuture httpResponseFuture, String channelID) {
        LOG.error("Error in HTTP client: {}", (Object)"Idle timeout triggered while writing outbound request entity body");
    }

    private void writeOutboundRequestBody(HttpContent lastHttpContent) {
        ChannelFuture outboundRequestChannelFuture = this.targetChannel.getChannel().writeAndFlush(lastHttpContent);
        this.checkForRequestWriteStatus(outboundRequestChannelFuture);
    }

    private void checkForRequestWriteStatus(ChannelFuture outboundRequestChannelFuture) {
        outboundRequestChannelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Connection between client and remote host is closed");
                }
                this.httpInboundResponseFuture.notifyHttpListener(throwable);
            } else {
                this.messageStateContext.setSenderState(new RequestCompleted(this.messageStateContext));
            }
        }));
    }
}

