/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.atomic.AtomicInteger;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.message.Listener;

public class DefaultListener
implements Listener {
    private static final int MAXIMUM_BYTE_SIZE = 0x200000;
    private AtomicInteger cumulativeByteQuantity = new AtomicInteger(0);
    private ChannelHandlerContext ctx;
    private boolean readCompleted = false;
    private boolean first = true;

    public DefaultListener(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void onAdd(HttpContent httpContent) {
        int count;
        if (this.first) {
            this.ctx.channel().config().setAutoRead(false);
            this.first = false;
        }
        if ((count = this.cumulativeByteQuantity.addAndGet(httpContent.content().readableBytes())) < 0x200000 && !this.readCompleted) {
            if (Util.isLastHttpContent(httpContent)) {
                this.readCompleted = true;
                this.ctx.channel().config().setAutoRead(true);
                this.ctx = null;
            } else {
                this.ctx.channel().read();
            }
        }
    }

    @Override
    public void onRemove(HttpContent httpContent) {
        int count = this.cumulativeByteQuantity.addAndGet(-httpContent.content().readableBytes());
        if (count < 0x200000 && !this.readCompleted) {
            this.ctx.channel().read();
        }
    }

    @Override
    public void resumeReadInterest() {
        if (this.ctx != null) {
            this.ctx.channel().config().setAutoRead(true);
        }
    }
}

