/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.SendingHeaders;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class EntityBodyReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final SourceHandler sourceHandler;
    private final float httpVersion;

    EntityBodyReceived(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler, float httpVersion) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        this.listenerReqRespStateManager.state = new SendingHeaders(this.listenerReqRespStateManager, outboundResponseListener);
        this.listenerReqRespStateManager.writeOutboundResponseHeaders(outboundResponseMsg, httpContent);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Remote client closed the connection before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", e);
        }
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", e);
        }
        String responseValue = "Idle timeout triggered before initiating outbound response";
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.copiedBuffer(responseValue, CharsetUtil.UTF_8), responseValue.length(), this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener(channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
        });
        return outboundRespFuture;
    }
}

