/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging.handler;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.handler.MessagingHandler;

public class HandlerExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerExecutor.class);
    private Map<String, MessagingHandler> handlers = new HashMap<String, MessagingHandler>();

    public boolean executeRequestContinuationValidator(CarbonMessage carbonMessage, CarbonCallback callback) {
        try {
            this.handlers.forEach((k, v) -> v.validateRequestContinuation(carbonMessage, callback));
            for (Map.Entry<String, MessagingHandler> messagingHandlerEntry : this.handlers.entrySet()) {
                if (messagingHandlerEntry.getValue().validateRequestContinuation(carbonMessage, callback)) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source connection initiation ", e);
        }
        return true;
    }

    public void executeAtSourceConnectionInitiation(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceConnectionInitiation(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source connection initiation ", e);
        }
    }

    public void executeAtSourceConnectionTermination(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceConnectionTermination(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source connection termination ", e);
        }
    }

    public void executeAtSourceRequestReceiving(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceRequestReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source request receiving ", e);
        }
    }

    public void executeAtSourceRequestSending(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceRequestSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source request sending ", e);
        }
    }

    public void executeAtTargetRequestReceiving(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetRequestReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target request receiving ", e);
        }
    }

    public void executeAtTargetRequestSending(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetRequestSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target request sending ", e);
        }
    }

    public void executeAtTargetResponseReceiving(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetResponseReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target response receiving ", e);
        }
    }

    public void executeAtTargetResponseSending(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetResponseSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target response sending ", e);
        }
    }

    public void executeAtSourceResponseReceiving(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceResponseReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source response receiving ", e);
        }
    }

    public void executeAtSourceResponseSending(CarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceResponseSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source response sending ", e);
        }
    }

    public void executeAtTargetConnectionInitiation(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetConnectionInitiation(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target connection initiation ", e);
        }
    }

    public void executeAtTargetConnectionTermination(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetConnectionTermination(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target connection termination ", e);
        }
    }

    public void addHandler(MessagingHandler messagingHandler) {
        this.handlers.put(messagingHandler.handlerName(), messagingHandler);
        LOG.info("A new handler named " + messagingHandler.handlerName() + " is added to the Handler Executor");
    }

    public void removeHandler(MessagingHandler messagingHandler) {
        this.handlers.remove(messagingHandler.handlerName());
        LOG.info("Handler named " + messagingHandler.handlerName() + " is removed from the Handler Executor");
    }
}

