/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2Content;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.message.DefaultBackPressureListener;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.Http2InboundContentListener;
import org.wso2.transport.http.netty.message.Http2PassthroughBackPressureListener;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PassthroughBackPressureListener;

public class RequestWriteStarter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestWriteStarter.class);
    private final OutboundMsgHolder outboundMsgHolder;
    private final Http2ClientChannel http2ClientChannel;

    public RequestWriteStarter(OutboundMsgHolder outboundMsgHolder, Http2ClientChannel http2ClientChannel) {
        this.outboundMsgHolder = outboundMsgHolder;
        this.http2ClientChannel = http2ClientChannel;
    }

    public void startWritingContent() {
        this.setBackPressureListener();
        this.outboundMsgHolder.setFirstContentWritten(false);
        this.outboundMsgHolder.getRequest().getHttpContentAsync().setMessageListener(httpContent -> {
            this.checkStreamUnwritability();
            this.http2ClientChannel.getChannel().eventLoop().execute(() -> {
                Http2Content http2Content = new Http2Content(httpContent, this.outboundMsgHolder);
                this.http2ClientChannel.getChannel().write(http2Content);
            });
        });
    }

    private void setBackPressureListener() {
        if (this.outboundMsgHolder.getRequest().isPassthrough()) {
            this.setPassthroughBackOffListener();
        } else {
            this.outboundMsgHolder.getBackPressureObservable().setListener(new DefaultBackPressureListener());
        }
    }

    private void setPassthroughBackOffListener() {
        Listener inboundListener = this.outboundMsgHolder.getRequest().getListener();
        if (inboundListener instanceof Http2InboundContentListener) {
            this.outboundMsgHolder.getBackPressureObservable().setListener(new Http2PassthroughBackPressureListener((Http2InboundContentListener)inboundListener));
        } else if (inboundListener instanceof DefaultListener) {
            this.outboundMsgHolder.getBackPressureObservable().setListener(new PassthroughBackPressureListener(this.outboundMsgHolder.getRequest().getSourceContext()));
        }
    }

    private void checkStreamUnwritability() {
        if (!this.outboundMsgHolder.isStreamWritable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream is not writable.", (Object)Thread.currentThread().getName());
            }
            this.outboundMsgHolder.getBackPressureObservable().notifyUnWritable();
        }
    }
}

