/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final SenderReqRespStateManager senderReqRespStateManager;
    private TargetHandler targetHandler;

    ReceivingHeaders(SenderReqRespStateManager senderReqRespStateManager) {
        this.senderReqRespStateManager = senderReqRespStateManager;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestEntity {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        this.targetHandler = targetHandler;
        OutboundMsgHolder msgHolder = targetHandler.getHttp2TargetHandler().getHttp2ClientChannel().getInFlightMessage(1);
        if (msgHolder != null) {
            msgHolder.markNoPromisesReceived();
        }
        if (targetHandler.getHttpResponseFuture() != null) {
            HttpCarbonMessage inboundResponseMsg = targetHandler.getInboundResponseMsg();
            inboundResponseMsg.setTargetContext(targetHandler.getContext());
            targetHandler.getHttpResponseFuture().notifyHttpListener(inboundResponseMsg);
        } else {
            LOG.error("Cannot notify the response to client as there is no associated responseFuture");
        }
        if (httpInboundResponse.decoderResult().isFailure()) {
            LOG.debug(httpInboundResponse.decoderResult().cause().getMessage());
        }
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        this.senderReqRespStateManager.state = new ReceivingEntityBody(this.senderReqRespStateManager, this.targetHandler);
        this.senderReqRespStateManager.readInboundResponseEntityBody(ctx, httpContent, inboundResponseMsg);
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Remote host closed the connection while reading inbound response headers");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Idle timeout triggered while reading inbound response headers");
    }
}

