/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.sample.websocket.chatapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.websocket.WebSocketEndpoint;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

@ServerEndpoint(value="/chat/{name}")
@Component(name="org.wso2.msf4j.chatApp", service={WebSocketEndpoint.class}, immediate=true)
public class ChatAppEndpoint
implements WebSocketEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatAppEndpoint.class);
    private List<WebSocketConnection> webSocketConnections = new ArrayList<WebSocketConnection>();

    @OnOpen
    public void onOpen(@PathParam(value="name") String name, WebSocketConnection webSocketConnection) {
        this.webSocketConnections.add(webSocketConnection);
        String msg = name + " connected to chat";
        LOGGER.info(msg);
        this.sendMessageToAll(msg);
    }

    @OnMessage
    public void onTextMessage(@PathParam(value="name") String name, String text, WebSocketConnection webSocketConnection) throws IOException {
        String msg = name + " : " + text;
        LOGGER.info("Received Text : " + text + " from  " + name + webSocketConnection.getChannelId());
        this.sendMessageToAll(msg);
    }

    @OnClose
    public void onClose(@PathParam(value="name") String name, CloseReason closeReason, WebSocketConnection webSocketConnection) {
        LOGGER.info("Connection is closed with status code : " + closeReason.getCloseCode().getCode() + " On reason " + closeReason.getReasonPhrase());
        this.webSocketConnections.remove(webSocketConnection);
        String msg = name + " left the chat";
        this.sendMessageToAll(msg);
    }

    @OnError
    public void onError(Throwable throwable) {
        LOGGER.error("Error found in method : " + throwable.toString());
    }

    private void sendMessageToAll(String message) {
        this.webSocketConnections.forEach(webSocketConnection -> webSocketConnection.pushText(message));
    }
}

