/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault;

import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.MasterKeyReader;
import org.wso2.carbon.secvault.SecretRepository;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.secvault.SecureVaultUtils;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.internal.SecureVaultDataHolder;
import org.wso2.carbon.secvault.internal.SecureVaultImpl;
import org.wso2.carbon.secvault.model.SecureVaultConfiguration;

public class SecureVaultFactory {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultFactory.class);

    public static Optional<SecureVault> getSecureVault(Path secureVaultConfigPath) throws SecureVaultException {
        SecretRepository secretRepository;
        MasterKeyReader masterKeyReader;
        SecureVaultConfiguration secureVaultConfiguration = SecureVaultUtils.getSecureVaultConfig(secureVaultConfigPath).orElseThrow(() -> new SecureVaultException("Error occurred when obtaining secure vault configuration."));
        if (SecureVaultUtils.isOSGIEnv()) {
            masterKeyReader = SecureVaultDataHolder.getInstance().getMasterKeyReader().orElseThrow(() -> new SecureVaultException("Master key reader type is not set"));
            secretRepository = SecureVaultDataHolder.getInstance().getSecretRepository().orElseThrow(() -> new SecureVaultException("Secret repository type is not set"));
        } else {
            String masterKeyReaderType = secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is not set"));
            masterKeyReader = SecureVaultFactory.createInstance(masterKeyReaderType, MasterKeyReader.class);
            SecureVaultDataHolder.getInstance().setMasterKeyReader(masterKeyReader);
            String secretRepositoryType = secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is not set"));
            secretRepository = SecureVaultFactory.createInstance(secretRepositoryType, SecretRepository.class);
            SecureVaultDataHolder.getInstance().setSecretRepository(secretRepository);
        }
        SecureVault secureVault = SecureVaultFactory.getSecureVault(secureVaultConfiguration, masterKeyReader, secretRepository);
        logger.debug("Secure Vault initialized successfully");
        return Optional.ofNullable(secureVault);
    }

    private static SecureVault getSecureVault(SecureVaultConfiguration secureVaultConfiguration, MasterKeyReader masterKeyReader, SecretRepository secretRepository) throws SecureVaultException {
        logger.debug("Initializing the secure vault with, SecretRepositoryType={}, MasterKeyReaderType={}", (Object)secretRepository.getClass().getName(), (Object)masterKeyReader.getClass().getName());
        masterKeyReader.init(secureVaultConfiguration.getMasterKeyReaderConfig());
        secretRepository.init(secureVaultConfiguration.getSecretRepositoryConfig(), masterKeyReader);
        secretRepository.loadSecrets(secureVaultConfiguration.getSecretRepositoryConfig());
        return new SecureVaultImpl();
    }

    private static <T> T createInstance(String className, Class<T> baseClass) throws SecureVaultException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!baseClass.isAssignableFrom(clazz)) {
                throw new InstantiationException("Class " + className + " is not of the required base type");
            }
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SecureVaultException("Error when creating an instance of the class" + className, e);
        }
    }
}

