/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BufferFactory;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerChannelInitializer;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnector;
import org.wso2.carbon.transport.http.netty.listener.ServerBootstrapConfiguration;

public class ServerConnectorController {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorController.class);
    private ServerBootstrap bootstrap;
    private HTTPServerChannelInitializer handler;
    private TransportsConfiguration transportsConfiguration;
    private boolean initialized = false;

    public ServerConnectorController(TransportsConfiguration transportsConfiguration) {
        this.transportsConfiguration = transportsConfiguration;
    }

    public void start() {
        EventLoopGroup workerGroup;
        Set<TransportProperty> transportPropertiesSet = this.transportsConfiguration.getTransportProperties();
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        ServerBootstrapConfiguration.createBootStrapConfiguration(transportProperties);
        ServerBootstrapConfiguration serverBootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        EventLoopGroup bossGroup = HTTPTransportContextHolder.getInstance().getBossGroup();
        if (bossGroup == null) {
            int bossGroupSize = Util.getIntProperty(transportProperties, "server.bootstrap.boss.group.size", Runtime.getRuntime().availableProcessors());
            bossGroup = new NioEventLoopGroup(bossGroupSize);
            HTTPTransportContextHolder.getInstance().setBossGroup(bossGroup);
        }
        if ((workerGroup = HTTPTransportContextHolder.getInstance().getWorkerGroup()) == null) {
            int workerGroupSize = Util.getIntProperty(transportProperties, "server.bootstrap.worker.group.size", Runtime.getRuntime().availableProcessors() * 2);
            workerGroup = new NioEventLoopGroup(workerGroupSize);
            HTTPTransportContextHolder.getInstance().setWorkerGroup(workerGroup);
        }
        HTTPTransportContextHolder.getInstance().setHandlerExecutor(new HandlerExecutor());
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
        this.handler = new HTTPServerChannelInitializer();
        this.handler.setupConnectionManager(transportProperties);
        this.bootstrap.childHandler(this.handler);
        int bufferSize = Util.getIntProperty(transportProperties, "output.content.buffer.size", 0);
        if (bufferSize != 0) {
            BufferFactory.createInstance(bufferSize);
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, serverBootstrapConfiguration.getSoBackLog());
        log.debug("Netty Server Socket BACKLOG " + serverBootstrapConfiguration.getSoBackLog());
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, serverBootstrapConfiguration.isTcpNoDelay());
        log.debug("Netty Server Socket TCP_NODELAY " + serverBootstrapConfiguration.isTcpNoDelay());
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, serverBootstrapConfiguration.isKeepAlive());
        log.debug("Netty Server Socket SO_KEEPALIVE " + serverBootstrapConfiguration.isKeepAlive());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverBootstrapConfiguration.getConnectTimeOut());
        log.debug(" Netty Server Socket CONNECT_TIMEOUT_MILLIS " + serverBootstrapConfiguration.getConnectTimeOut());
        this.bootstrap.option(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        this.bootstrap.option(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReceiveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReceiveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        this.initialized = true;
    }

    public void stop() {
        this.handler.getConnectionManager().getTargetChannelPool().clear();
        this.shutdownEventLoops();
    }

    private void shutdownEventLoops() {
        try {
            EventLoopGroup workerGroup;
            EventLoopGroup bossGroup = HTTPTransportContextHolder.getInstance().getBossGroup();
            if (bossGroup != null) {
                bossGroup.shutdownGracefully().sync();
                HTTPTransportContextHolder.getInstance().setBossGroup(null);
            }
            if ((workerGroup = HTTPTransportContextHolder.getInstance().getWorkerGroup()) != null) {
                workerGroup.shutdownGracefully().sync();
                HTTPTransportContextHolder.getInstance().setWorkerGroup(null);
            }
            log.info("HTTP transport event loops stopped successfully");
        }
        catch (InterruptedException e) {
            log.error("Error while shutting down event loops " + e.getMessage());
        }
    }

    public boolean bindInterface(HTTPServerConnector serverConnector) {
        if (!this.initialized) {
            log.error("ServerConnectorController is not initialized");
            return false;
        }
        try {
            ListenerConfiguration listenerConfiguration = serverConnector.getListenerConfiguration();
            SslContext http2sslContext = null;
            if (listenerConfiguration.isHttp2() && listenerConfiguration.getSslConfig() != null) {
                http2sslContext = new SSLHandlerFactory(listenerConfiguration.getSslConfig()).createHttp2TLSContext();
            }
            this.handler.registerListenerConfig(listenerConfiguration, http2sslContext);
            ChannelFuture future = this.bootstrap.bind(new InetSocketAddress(listenerConfiguration.getHost(), listenerConfiguration.getPort())).sync();
            serverConnector.setChannelFuture(future);
            if (future.isSuccess()) {
                String msg = "Started listener " + listenerConfiguration.getScheme() + "-" + listenerConfiguration.getPort();
                log.info(msg);
                if (listenerConfiguration.getSslConfig() == null) {
                    log.info("HTTP Interface " + listenerConfiguration.getId() + " starting on host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                } else {
                    log.info("HTTPS Interface " + listenerConfiguration.getId() + " starting on host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                }
                return true;
            }
            log.error("Cannot bind port for host " + listenerConfiguration.getHost() + " port " + listenerConfiguration.getPort());
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
        catch (SSLException e) {
            log.error("Error occurred while configuring HTTP/2 SSL context for host " + serverConnector.getListenerConfiguration().getHost() + " port " + serverConnector.getListenerConfiguration().getPort());
        }
        return false;
    }

    public boolean unBindInterface(HTTPServerConnector serverConnector) {
        if (!this.initialized) {
            log.error("ServerConnectorController is not initialized");
            return false;
        }
        ListenerConfiguration listenerConfiguration = serverConnector.getListenerConfiguration();
        this.handler.unRegisterListenerConfig(listenerConfiguration);
        ChannelFuture future = serverConnector.getChannelFuture();
        if (future != null) {
            future.channel().close();
            if (listenerConfiguration.getSslConfig() == null) {
                log.info("HTTP Listener stopped on listening interface " + listenerConfiguration.getId() + " attached to host " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
            } else {
                log.info("HTTPS Listener stopped on listening interface " + listenerConfiguration.getId() + " attached to host " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
            }
            return true;
        }
        return false;
    }

    public TransportsConfiguration getTransportsConfiguration() {
        return this.transportsConfiguration;
    }
}

