/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.StatusCarbonMessage;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.internal.websocket.Util;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.carbon.transport.http.netty.listener.ResponseCallback;
import org.wso2.carbon.transport.http.netty.listener.WebSocketCallback;
import org.wso2.carbon.transport.http.netty.listener.WebSocketSourceHandler;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(SourceHandler.class);
    protected ChannelHandlerContext ctx;
    protected HTTPCarbonMessage cMsg;
    protected ConnectionManager connectionManager;
    protected Map<String, GenericObjectPool> targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
    protected ListenerConfiguration listenerConfiguration;
    private WebSocketServerHandshaker handshaker;

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }

    public SourceHandler(ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) throws Exception {
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage = (FullHttpMessage)msg;
            this.cMsg = (HTTPCarbonMessage)this.setupCarbonMessage(fullHttpMessage);
            this.publishToMessageProcessor(this.cMsg);
            ByteBuf content = ((FullHttpMessage)msg).content();
            this.cMsg.addHttpContent(new DefaultLastHttpContent(content));
            this.cMsg.setEndOfMsgAdded(true);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
            }
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpHeaders headers = httpRequest.headers();
            if (this.isConnectionUpgrade(headers) && "websocket".equalsIgnoreCase(headers.get("Upgrade"))) {
                log.info("Upgrading the connection from Http to WebSocket for channel : " + ctx.channel());
                this.handleWebSocketHandshake(httpRequest);
            } else {
                this.cMsg = (HTTPCarbonMessage)this.setupCarbonMessage(httpRequest);
                this.publishToMessageProcessor(this.cMsg);
            }
        } else if (this.cMsg != null && msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.cMsg.addHttpContent(httpContent);
            if (msg instanceof LastHttpContent) {
                this.cMsg.setEndOfMsgAdded(true);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
                }
            }
        }
    }

    public boolean isConnectionUpgrade(HttpHeaders headers) {
        if (!headers.contains("Connection")) {
            return false;
        }
        String connectionHeaderValues = headers.get("Connection");
        for (String connectionValue : connectionHeaderValues.split(",")) {
            if (!"Upgrade".equalsIgnoreCase(connectionValue.trim())) continue;
            return true;
        }
        return false;
    }

    private void handleWebSocketHandshake(HttpRequest httpRequest) throws ProtocolException {
        try {
            boolean isSecured = false;
            if (this.listenerConfiguration.getSslConfig() != null) {
                isSecured = true;
            }
            String uri = httpRequest.uri();
            WebSocketSessionImpl serverSession = Util.getSession(this.ctx, isSecured, uri);
            WebSocketSourceHandler webSocketSourceHandler = new WebSocketSourceHandler(Util.getSessionID(this.ctx), this.connectionManager, this.listenerConfiguration, httpRequest, isSecured, this.ctx, serverSession);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.sendWebSocketOnOpenMessage(this.ctx, isSecured, uri, serverSession, new WebSocketCallback(countDownLatch), webSocketSourceHandler);
            countDownLatch.await();
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(httpRequest), null, true);
            this.handshaker = wsFactory.newHandshaker(httpRequest);
            this.handshaker.handshake(this.ctx.channel(), httpRequest);
            ChannelPipeline pipeline = this.ctx.pipeline();
            pipeline.addLast("ws_handler", (ChannelHandler)webSocketSourceHandler);
            pipeline.remove("idleStateHandler");
            pipeline.remove(this);
        }
        catch (Exception e) {
            this.ctx.channel().writeAndFlush(new CloseWebSocketFrame(1002, ""));
            this.ctx.close();
            throw new ProtocolException("Error occurred in HTTP to WebSocket Upgrade : " + e.getMessage());
        }
    }

    private void sendWebSocketOnOpenMessage(ChannelHandlerContext ctx, boolean isSecured, String uri, WebSocketSessionImpl serverSession, WebSocketCallback callback, WebSocketSourceHandler sourceHandler) throws URISyntaxException {
        StatusCarbonMessage statusCarbonMessage = new StatusCarbonMessage("STATUS_OPEN", 0, null);
        statusCarbonMessage.setProperty("TO", uri);
        statusCarbonMessage.setProperty("PROTOCOL", "ws");
        statusCarbonMessage.setProperty("IS_SECURED_CONNECTION", isSecured);
        statusCarbonMessage.setProperty("SRC_HANDLER", sourceHandler);
        statusCarbonMessage.setProperty("Connection", "Upgrade");
        statusCarbonMessage.setProperty("Upgrade", "websocket");
        statusCarbonMessage.setProperty("WEBSOCKET_SERVER_SESSION", serverSession);
        statusCarbonMessage.setProperty("IS_WEBSOCKET_SERVER", true);
        CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor(this.listenerConfiguration.getMessageProcessorId());
        if (carbonMessageProcessor != null) {
            try {
                carbonMessageProcessor.receive(statusCarbonMessage, callback);
            }
            catch (Exception e) {
                log.error("Error while submitting CarbonMessage to CarbonMessageProcessor", e);
            }
        } else {
            log.error("Cannot find registered MessageProcessor for forward the message");
        }
    }

    private String getWebSocketURL(HttpRequest req) {
        String protocol = "ws";
        if (this.listenerConfiguration.getSslConfig() != null) {
            protocol = "wss";
        }
        String url = protocol + "://" + req.headers().get("Host") + req.getUri();
        return url;
    }

    protected void publishToMessageProcessor(CarbonMessage cMsg) throws URISyntaxException {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        boolean continueRequest = true;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            continueRequest = HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeRequestContinuationValidator(cMsg, carbonMessage -> {
                CarbonCallback responseCallback = (CarbonCallback)cMsg.getProperty("CALL_BACK");
                responseCallback.done(carbonMessage);
            });
        }
        if (continueRequest) {
            CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor(this.listenerConfiguration.getMessageProcessorId());
            if (carbonMessageProcessor != null) {
                try {
                    carbonMessageProcessor.receive(cMsg, new ResponseCallback(this.ctx, cMsg));
                }
                catch (Exception e) {
                    log.error("Error while submitting CarbonMessage to CarbonMessageProcessor", e);
                }
            } else {
                log.error("Cannot find registered MessageProcessor for forward the message");
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        this.targetChannelPool.forEach((k, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(k).close();
            }
            catch (Exception e) {
                log.error("Couldn't close target channel socket connections", e);
            }
        });
        this.connectionManager.notifyChannelInactive();
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected CarbonMessage setupCarbonMessage(HttpMessage httpMessage) throws URISyntaxException {
        this.cMsg = new HTTPCarbonMessage();
        boolean isSecuredConnection = false;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        HttpRequest httpRequest = (HttpRequest)httpMessage;
        this.cMsg.setProperty("MESSAGE_PROCESSOR_ID", this.listenerConfiguration.getMessageProcessorId());
        this.cMsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        this.cMsg.setProperty("SRC_HANDLER", this);
        this.cMsg.setProperty("HTTP_VERSION", httpRequest.getProtocolVersion().text());
        this.cMsg.setProperty("HTTP_METHOD", httpRequest.getMethod().name());
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("LISTENER_INTERFACE_ID", this.listenerConfiguration.getId());
        this.cMsg.setProperty("PROTOCOL", "http");
        if (this.listenerConfiguration.getSslConfig() != null) {
            isSecuredConnection = true;
        }
        this.cMsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        this.cMsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        this.cMsg.setProperty("REQUEST_URL", httpRequest.getUri());
        ChannelHandler handler = this.ctx.handler();
        this.cMsg.setProperty("CHANNEL_ID", ((SourceHandler)handler).getListenerConfiguration().getId());
        this.cMsg.setProperty("TO", httpRequest.getUri());
        this.cMsg.setHeaders(org.wso2.carbon.transport.http.netty.common.Util.getHeaders(httpRequest).getAll());
        return this.cMsg;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.close();
        }
    }
}

