/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.wso2.msf4j.Request;

public class MSF4JRequestInputStream
extends InputStream {
    private Request request;
    private ByteBuffer buffer;

    public MSF4JRequestInputStream(Request request) {
        this.request = request;
        this.buffer = request.getMessageBody();
    }

    @Override
    public int read() throws IOException {
        if (this.request.isEomAdded() && this.request.isEmpty() && !this.buffer.hasRemaining()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.buffer = this.request.getMessageBody();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

