/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.interceptor.ResponseInterceptor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.HttpConnectorPortBindingListener;
import org.wso2.msf4j.internal.MSF4JHttpConnectorListener;
import org.wso2.msf4j.internal.MSF4JWSConnectorListener;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.util.RuntimeAnnotations;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ConfigurationBuilder;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsConnectorFactoryImpl;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.message.HTTPConnectorUtil;

public class MicroservicesRunner {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRunner.class);
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final String TRANSPORTS_NETTY_CONF = "transports.netty.conf";
    private static final String MSF4J_HOST = "msf4j.host";
    protected List<ServerConnector> serverConnectors = new ArrayList<ServerConnector>();
    private EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
    private MicroservicesRegistryImpl msRegistry = new MicroservicesRegistryImpl();
    private long startTime = System.currentTimeMillis();
    private boolean isStarted;

    public MicroservicesRunner(int ... ports) {
        this.configureTransport(ports);
    }

    public MicroservicesRunner() {
        this.configureTransport();
    }

    public MicroservicesRunner deploy(Object ... microservice) {
        this.checkState();
        this.msRegistry.addService(microservice);
        return this;
    }

    public MicroservicesRunner deploy(String basePath, Object microservice) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("value", basePath);
        RuntimeAnnotations.putAnnotation(microservice.getClass(), Path.class, valuesMap);
        this.msRegistry.addService(basePath, microservice);
        return this;
    }

    public MicroservicesRunner deployWebSocketEndpoint(Object webSocketEndpoint) {
        this.endpointsRegistry.addEndpoint(webSocketEndpoint);
        return this;
    }

    public MicroservicesRunner setSessionManager(SessionManager sessionManager) {
        this.msRegistry.setSessionManager(sessionManager);
        return this;
    }

    public MicroservicesRunner addGlobalRequestInterceptor(RequestInterceptor ... requestInterceptor) {
        this.msRegistry.addGlobalRequestInterceptor(requestInterceptor);
        return this;
    }

    public MicroservicesRunner addGlobalResponseInterceptor(ResponseInterceptor ... responseInterceptor) {
        this.msRegistry.addGlobalResponseInterceptor(responseInterceptor);
        return this;
    }

    public MicroservicesRunner addInterceptor(Interceptor ... interceptor) {
        this.msRegistry.addGlobalRequestInterceptor(interceptor);
        this.msRegistry.addGlobalResponseInterceptor(interceptor);
        return this;
    }

    public MicroservicesRunner addExceptionMapper(ExceptionMapper ... exceptionMapper) {
        this.checkState();
        this.msRegistry.addExceptionMapper(exceptionMapper);
        return this;
    }

    protected void configureTransport(int ... ports) {
        HttpWsConnectorFactoryImpl connectorFactory = new HttpWsConnectorFactoryImpl();
        ServerBootstrapConfiguration bootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        for (int port : ports) {
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration("netty-" + port, System.getProperty(MSF4J_HOST, DEFAULT_HOST), port);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID(listenerConfiguration.getHost(), listenerConfiguration.getPort()), this.msRegistry);
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration);
            this.serverConnectors.add(serverConnector);
        }
    }

    protected void configureTransport() {
        HttpWsConnectorFactoryImpl connectorFactory = new HttpWsConnectorFactoryImpl();
        String transportYaml = System.getProperty(TRANSPORTS_NETTY_CONF);
        if (transportYaml == null || transportYaml.isEmpty()) {
            ServerBootstrapConfiguration bootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
            ListenerConfiguration listenerConfiguration = ListenerConfiguration.getDefault();
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID(listenerConfiguration.getHost(), listenerConfiguration.getPort()), this.msRegistry);
            this.serverConnectors.add(serverConnector);
        } else {
            TransportsConfiguration transportsConfiguration = ConfigurationBuilder.getInstance().getConfiguration(transportYaml);
            ServerBootstrapConfiguration serverBootstrapConfiguration = HTTPConnectorUtil.getServerBootstrapConfiguration(transportsConfiguration.getTransportProperties());
            for (ListenerConfiguration listenerConfiguration : transportsConfiguration.getListenerConfigurations()) {
                ServerConnector serverConnector = connectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfiguration);
                DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID(listenerConfiguration.getHost(), listenerConfiguration.getPort()), this.msRegistry);
                this.serverConnectors.add(serverConnector);
            }
        }
    }

    private void checkState() {
        if (this.isStarted) {
            throw new IllegalStateException("Microservices runner already started");
        }
    }

    public void start() {
        this.msRegistry.getSessionManager().init();
        this.handleServiceLifecycleMethods();
        MSF4JHttpConnectorListener msf4JHttpConnectorListener = new MSF4JHttpConnectorListener();
        MSF4JWSConnectorListener msf4JWSConnectorListener = new MSF4JWSConnectorListener();
        this.serverConnectors.forEach(serverConnector -> {
            ServerConnectorFuture serverConnectorFuture = serverConnector.start();
            serverConnectorFuture.setHttpConnectorListener(msf4JHttpConnectorListener);
            serverConnectorFuture.setWSConnectorListener(msf4JWSConnectorListener);
            serverConnectorFuture.setPortBindingEventListener(new HttpConnectorPortBindingListener());
            this.isStarted = true;
            log.info("Microservices server started in " + (System.currentTimeMillis() - this.startTime) + "ms");
        });
    }

    public void stop() {
        this.serverConnectors.forEach(ServerConnector::stop);
        log.info("Microservices server stopped");
    }

    public MicroservicesRegistryImpl getMsRegistry() {
        return this.msRegistry;
    }

    protected void handleServiceLifecycleMethods() {
        this.msRegistry.initServices();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MicroservicesRunner.this.msRegistry.preDestroyServices();
            }
        });
    }
}

