/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.sample.websocket.chatapp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/chat/{name}")
public class ChatAppEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatAppEndpoint.class);
    private List<Session> sessions = new LinkedList<Session>();

    @OnOpen
    public void onOpen(@PathParam(value="name") String name, Session session) {
        this.sessions.add(session);
        String msg = name + " connected to chat";
        LOGGER.info(msg);
        this.sendMessageToAll(msg);
    }

    @OnMessage
    public void onTextMessage(@PathParam(value="name") String name, String text, Session session) throws IOException {
        String msg = name + " : " + text;
        LOGGER.info("Received Text : " + text + " from  " + name + session.getId());
        this.sendMessageToAll(msg);
    }

    @OnMessage
    public void onBinaryMessage(byte[] bytes, Session session) {
        LOGGER.info("Reading binary Message");
        LOGGER.info(bytes.toString());
    }

    @OnClose
    public void onClose(@PathParam(value="name") String name, CloseReason closeReason, Session session) {
        LOGGER.info("Connection is closed with status code : " + closeReason.getCloseCode().getCode() + " On reason " + closeReason.getReasonPhrase());
        this.sessions.remove(session);
        String msg = name + " left the chat";
        this.sendMessageToAll(msg);
    }

    @OnError
    public void onError(Throwable throwable, Session session) {
        LOGGER.error("Error found in method : " + throwable.toString());
    }

    private void sendMessageToAll(String message) {
        this.sessions.forEach(session -> {
            try {
                session.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        });
    }
}

