/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.exception.EndpointTimeOutException;
import org.wso2.transport.http.netty.sender.http2.ClientOutboundHandler;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;

public class TimeoutHandler
implements Http2DataEventListener {
    private static final Logger log = LoggerFactory.getLogger(TimeoutHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private long idleTimeNanos;
    private Http2ClientChannel http2ClientChannel;
    private Map<Integer, ScheduledFuture<?>> timerTasks;

    public TimeoutHandler(long idleTimeMills, Http2ClientChannel http2ClientChannel) {
        this.idleTimeNanos = Math.max(TimeUnit.MILLISECONDS.toNanos(idleTimeMills), MIN_TIMEOUT_NANOS);
        this.http2ClientChannel = http2ClientChannel;
        this.timerTasks = new ConcurrentHashMap();
    }

    @Override
    public boolean onStreamInit(ChannelHandlerContext ctx, int streamId) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(this.ticksInNanos());
            this.timerTasks.put(streamId, this.schedule(ctx, new IdleTimeoutTask(ctx, streamId), this.idleTimeNanos, TimeUnit.NANOSECONDS));
        }
        return true;
    }

    @Override
    public boolean onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onPushPromiseRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onHeadersWrite(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public boolean onDataWrite(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public boolean onStreamReset(int streamId) {
        this.onStreamClose(streamId);
        return true;
    }

    @Override
    public boolean onStreamClose(int streamId) {
        ScheduledFuture<?> timerTask = this.timerTasks.get(streamId);
        if (timerTask != null) {
            timerTask.cancel(false);
            this.timerTasks.remove(streamId);
        }
        return true;
    }

    @Override
    public void destroy() {
        this.timerTasks.forEach((streamId, task) -> task.cancel(false));
        this.timerTasks.clear();
    }

    private void updateLastReadTime(int streamId, boolean endOfStream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(this.ticksInNanos());
        }
        if (endOfStream) {
            this.onStreamClose(streamId);
        }
    }

    private void updateLastWriteTime(int streamId) {
        OutboundMsgHolder msgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        msgHolder.setLastReadWriteTime(this.ticksInNanos());
    }

    private long ticksInNanos() {
        return System.nanoTime();
    }

    private void closeStream(int streamId, ChannelHandlerContext ctx) {
        ClientOutboundHandler clientOutboundHandler = (ClientOutboundHandler)ctx.pipeline().get("outboundHandler");
        clientOutboundHandler.resetStream(ctx, streamId, Http2Error.STREAM_CLOSED);
    }

    private ScheduledFuture<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay, TimeUnit unit) {
        return ctx.executor().schedule(task, delay, unit);
    }

    private class IdleTimeoutTask
    implements Runnable {
        private ChannelHandlerContext ctx;
        private OutboundMsgHolder msgHolder;
        private int streamId;

        public IdleTimeoutTask(ChannelHandlerContext ctx, int streamId) {
            this.ctx = ctx;
            this.streamId = streamId;
            this.msgHolder = TimeoutHandler.this.http2ClientChannel.getInFlightMessage(streamId);
        }

        @Override
        public void run() {
            long nextDelay = TimeoutHandler.this.idleTimeNanos - (TimeoutHandler.this.ticksInNanos() - this.msgHolder.getLastReadWriteTime());
            if (nextDelay <= 0L) {
                TimeoutHandler.this.closeStream(this.streamId, this.ctx);
                if (this.msgHolder.getResponse() != null) {
                    this.handleIncompleteInboundResponse("Idle timeout triggered while reading inbound response");
                } else if (this.msgHolder.isRequestWritten()) {
                    this.msgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered before reading inbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
                } else {
                    this.msgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered while writing outbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
                }
                TimeoutHandler.this.http2ClientChannel.removeInFlightMessage(this.streamId);
            } else {
                TimeoutHandler.this.timerTasks.put(this.streamId, TimeoutHandler.this.schedule(this.ctx, this, nextDelay, TimeUnit.NANOSECONDS));
            }
        }

        private void handleIncompleteInboundResponse(String errorMessage) {
            DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
            lastHttpContent.setDecoderResult(DecoderResult.failure(new DecoderException(errorMessage)));
            this.msgHolder.getResponse().addHttpContent(lastHttpContent);
            log.warn(errorMessage);
        }
    }
}

