/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.wso2.transport.http.netty.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.common.certificatevalidation.ocsp.OCSPCache;
import org.wso2.transport.http.netty.common.certificatevalidation.ocsp.OCSPVerifier;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;

public class OCSPResponseBuilder {
    private static OCSPResp response = null;

    public static OCSPResp generatetOcspResponse(SSLConfig sslConfig, int cacheAllcatedSize, int cacheDelay) throws IOException, KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, CertificateVerificationException {
        X509Certificate userCertificate = null;
        X509Certificate issuer = null;
        int cacheSize = 50;
        int cacheDelayMins = 15;
        if (cacheAllcatedSize != 0 && cacheAllcatedSize > 50 && cacheAllcatedSize < 10000) {
            cacheSize = cacheAllcatedSize;
        }
        if (cacheDelay != 0 && cacheDelay > 1 && cacheDelay < 1440) {
            cacheDelayMins = cacheDelay;
        }
        OCSPCache ocspCache = OCSPCache.getCache();
        ocspCache.init(cacheSize, cacheDelayMins);
        KeyStore keyStore = OCSPResponseBuilder.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePass(), sslConfig.getTLSStoreType());
        Enumeration<String> aliases = keyStore.aliases();
        String alias = "";
        boolean isAliasWithPrivateKey = false;
        while (aliases.hasMoreElements() && !(isAliasWithPrivateKey = keyStore.isKeyEntry(alias = aliases.nextElement()))) {
        }
        if (isAliasWithPrivateKey) {
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            userCertificate = (X509Certificate)certificateChain[0];
            issuer = (X509Certificate)certificateChain[certificateChain.length - 1];
        }
        List<String> locations = null;
        if (userCertificate != null) {
            if (ocspCache.getOCSPCacheValue(userCertificate.getSerialNumber()) != null) {
                return ocspCache.getOCSPCacheValue(userCertificate.getSerialNumber());
            }
            OCSPReq request = null;
            try {
                request = OCSPVerifier.generateOCSPRequest(issuer, userCertificate.getSerialNumber());
            }
            catch (CertificateVerificationException e) {
                throw new CertificateVerificationException("Failed to generate OCSP request", e);
            }
            locations = OCSPResponseBuilder.getAIALocations(userCertificate);
            return OCSPResponseBuilder.getOCSPResponse(locations, request, userCertificate, ocspCache);
        }
        throw new CertificateVerificationException("Could not get revocation status from OCSP. Response Status :" + response.getStatus());
    }

    public static KeyStore getKeyStore(File keyStoreFile, String keyStorePassword, String tlsStoreType) throws IOException {
        KeyStore keyStore = null;
        if (keyStoreFile != null && keyStorePassword != null) {
            try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
                keyStore = KeyStore.getInstance(tlsStoreType);
                keyStore.load(inputStream, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return keyStore;
    }

    public static List<String> getAIALocations(X509Certificate userCertificate) throws CertificateVerificationException {
        List<String> locations = null;
        try {
            locations = OCSPVerifier.getAIALocations(userCertificate);
        }
        catch (CertificateVerificationException e) {
            throw new CertificateVerificationException("Failed to find AIA locations in the cetificate", e);
        }
        return locations;
    }

    private static OCSPResp getOCSPResponse(List<String> locations, OCSPReq request, X509Certificate userCertificate, OCSPCache ocspCache) throws CertificateVerificationException {
        SingleResp[] responses = null;
        CertificateStatus certificateStatus = null;
        for (String serviceUrl : locations) {
            try {
                response = OCSPVerifier.getOCSPResponce(serviceUrl, request);
                if (0 != response.getStatus()) continue;
                BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
                responses = basicResponse == null ? null : basicResponse.getResponses();
            }
            catch (OCSPException e) {
                continue;
            }
            if (responses == null || responses.length != 1) continue;
            SingleResp singleResponse = responses[0];
            certificateStatus = singleResponse.getCertStatus();
            if (certificateStatus != null) {
                throw new IllegalStateException("certificate-status=" + certificateStatus);
            }
            if (!userCertificate.getSerialNumber().equals(singleResponse.getCertID().getSerialNumber())) {
                throw new IllegalStateException("Bad Serials=" + userCertificate.getSerialNumber() + " vs. " + singleResponse.getCertID().getSerialNumber());
            }
            ocspCache.setCacheValue(response, userCertificate.getSerialNumber(), singleResponse, request, serviceUrl);
            return response;
        }
        throw new CertificateVerificationException("Could not get revocation status from OCSP. Response Status :" + response.getStatus());
    }
}

