/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.crl;

import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.MBeanRegistrar;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.CacheController;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.CacheManager;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCache;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCacheValue;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.crl.CRLVerifier;

public class CRLCache
implements ManageableCache {
    private static volatile CRLCache cache;
    private static volatile Map<String, CRLCacheValue> hashMap;
    private volatile Iterator<Map.Entry<String, CRLCacheValue>> iterator = hashMap.entrySet().iterator();
    private volatile CacheManager cacheManager;
    private static CRLVerifier crlVerifier;
    private static final Logger LOG;

    private CRLCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRLCache getCache() {
        if (cache != null) return cache;
        Class<CRLCache> clazz = CRLCache.class;
        synchronized (CRLCache.class) {
            if (cache != null) return cache;
            cache = new CRLCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (this.cacheManager != null) return;
        Class<CRLCache> clazz = CRLCache.class;
        synchronized (CRLCache.class) {
            if (this.cacheManager != null) return;
            this.cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, this.cacheManager);
            MBeanRegistrar.getInstance().registerMBean(mbean, "CacheController", "CRLCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized ManageableCacheValue getNextCacheValue() {
        if (this.iterator.hasNext()) {
            return hashMap.get(this.iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public synchronized int getCacheSize() {
        return hashMap.size();
    }

    @Override
    public void resetIterator() {
        this.iterator = hashMap.entrySet().iterator();
    }

    public synchronized X509CRL getCacheValue(String crlUrl) {
        CRLCacheValue cacheValue = hashMap.get(crlUrl);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                CRLCacheValue crlCacheValue = hashMap.get(crlUrl);
                return crlCacheValue != null ? crlCacheValue.getValue() : null;
            }
            return cacheValue.getValue();
        }
        return null;
    }

    public synchronized void setCacheValue(String crlUrl, X509CRL crl) {
        CRLCacheValue cacheValue = new CRLCacheValue(crlUrl, crl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before setting - HashMap size {}", (Object)hashMap.size());
        }
        hashMap.put(crlUrl, cacheValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After setting - HashMap size {}", (Object)hashMap.size());
        }
    }

    public synchronized void removeCacheValue(String crlUrl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before removing - HashMap size {}", (Object)hashMap.size());
        }
        hashMap.remove(crlUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After removing - HashMap size {}", (Object)hashMap.size());
        }
    }

    static {
        hashMap = new ConcurrentHashMap<String, CRLCacheValue>();
        crlVerifier = new CRLVerifier(null);
        LOG = LoggerFactory.getLogger(CRLCache.class);
    }

    private class CRLCacheValue
    implements ManageableCacheValue {
        private String crlUrl;
        private X509CRL crl;
        private long timeStamp = System.currentTimeMillis();

        public CRLCacheValue(String crlUrl, X509CRL crl) {
            this.crlUrl = crlUrl;
            this.crl = crl;
        }

        public String getKey() {
            return this.crlUrl;
        }

        public X509CRL getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.crl;
        }

        @Override
        public boolean isValid() {
            Date today = new Date();
            Date nextUpdate = this.crl.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(today);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            CRLCache.this.removeCacheValue(this.crlUrl);
        }

        @Override
        public void updateCacheWithNewValue() {
            this.replaceNewCacheValue();
        }

        private synchronized void replaceNewCacheValue() {
            if (this.isValid()) {
                return;
            }
            try {
                X509CRL x509CRL = crlVerifier.downloadCRLFromWeb(this.crlUrl);
                CRLCache.this.setCacheValue(this.crlUrl, x509CRL);
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Cannot replace old CacheValue with new CacheValue. So remove", e);
                }
                this.removeThisCacheValue();
            }
        }
    }
}

