/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.states;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SenderReqRespStateManager {
    public SenderState state;
    private final Channel nettyTargetChannel;

    public SenderReqRespStateManager(Channel nettyTargetChannel) {
        this.nettyTargetChannel = nettyTargetChannel;
    }

    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        this.state.writeOutboundRequestHeaders(httpOutboundRequest, httpContent);
    }

    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        this.state.writeOutboundRequestEntity(httpOutboundRequest, httpContent);
    }

    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        this.state.readInboundResponseHeaders(targetHandler, httpInboundResponse);
    }

    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        this.state.readInboundResponseEntityBody(ctx, httpContent, inboundResponseMsg);
    }

    public void handleAbruptChannelClosure(HttpResponseFuture httpResponseFuture) {
        this.state.handleAbruptChannelClosure(httpResponseFuture);
    }

    public void handleIdleTimeoutConnectionClosure(HttpResponseFuture httpResponseFuture, String channelID) {
        this.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.nettyTargetChannel.close();
        this.state.handleIdleTimeoutConnectionClosure(httpResponseFuture, channelID);
    }

    public void configIdleTimeoutTrigger(int socketIdleTimeout) {
        ChannelPipeline pipeline = this.nettyTargetChannel.pipeline();
        IdleStateHandler idleStateHandler = new IdleStateHandler(0L, 0L, socketIdleTimeout, TimeUnit.MILLISECONDS);
        if (pipeline.get("targetHandler") == null) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        } else {
            pipeline.addBefore("targetHandler", "idleStateHandler", idleStateHandler);
        }
    }
}

