/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.exception.InterceptorException;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;
import org.wso2.msf4j.interceptor.annotation.ResponseInterceptor;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.util.ReflectionUtils;

public class InterceptorExecutor {
    private InterceptorExecutor() {
    }

    public static boolean executeGlobalRequestInterceptors(MicroservicesRegistryImpl microServicesRegistry, Request request, Response response) {
        List<org.wso2.msf4j.interceptor.RequestInterceptor> globalRequestInterceptorList = microServicesRegistry.getGlobalRequestInterceptorList();
        return InterceptorExecutor.executeGlobalRequestInterceptors(request, response, globalRequestInterceptorList);
    }

    public static boolean executeClassLevelRequestInterceptors(Request request, Response response, Class<?> resourceClass) throws InterceptorException {
        ArrayList<Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor>> classRequestInterceptorClasses = resourceClass.isAnnotationPresent(RequestInterceptor.class) ? Arrays.asList(resourceClass.getAnnotation(RequestInterceptor.class).value()) : new ArrayList<Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor>>();
        return InterceptorExecutor.executeNonGlobalRequestInterceptors(request, response, classRequestInterceptorClasses);
    }

    public static boolean executeMethodLevelRequestInterceptors(Request request, Response response, Method method) throws InterceptorException {
        ArrayList<Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor>> methodRequestInterceptorClasses = method.isAnnotationPresent(RequestInterceptor.class) ? Arrays.asList(method.getAnnotation(RequestInterceptor.class).value()) : new ArrayList<Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor>>();
        return InterceptorExecutor.executeNonGlobalRequestInterceptors(request, response, methodRequestInterceptorClasses);
    }

    public static boolean executeGlobalResponseInterceptors(MicroservicesRegistryImpl microServicesRegistry, Request request, Response response) {
        List<org.wso2.msf4j.interceptor.ResponseInterceptor> globalResponseInterceptorList = microServicesRegistry.getGlobalResponseInterceptorList();
        return InterceptorExecutor.executeGlobalResponseInterceptors(request, response, globalResponseInterceptorList);
    }

    public static boolean executeClassLevelResponseInterceptors(Request request, Response response, Class<?> resourceClass) throws InterceptorException {
        ArrayList<Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor>> classResponseInterceptorClasses = resourceClass.isAnnotationPresent(ResponseInterceptor.class) ? Arrays.asList(resourceClass.getAnnotation(ResponseInterceptor.class).value()) : new ArrayList<Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor>>();
        return InterceptorExecutor.executeNonGlobalResponseInterceptors(request, response, classResponseInterceptorClasses);
    }

    public static boolean executeClassResponseInterceptorsForClasses(Request request, Response response, List<Class<?>> classes) throws InterceptorException {
        if (classes == null) {
            return true;
        }
        for (Class<?> aClass : classes) {
            if (InterceptorExecutor.executeClassLevelResponseInterceptors(request, response, aClass)) continue;
            return false;
        }
        return true;
    }

    public static boolean executeMethodLevelResponseInterceptors(Request request, Response response, Method method) throws InterceptorException {
        ArrayList<Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor>> methodResponseInterceptorClasses = method.isAnnotationPresent(ResponseInterceptor.class) ? Arrays.asList(method.getAnnotation(ResponseInterceptor.class).value()) : new ArrayList<Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor>>();
        return InterceptorExecutor.executeNonGlobalResponseInterceptors(request, response, methodResponseInterceptorClasses);
    }

    public static boolean executeMethodResponseInterceptorsForMethods(Request request, Response response, List<Method> methods) throws InterceptorException {
        if (methods == null) {
            return true;
        }
        for (Method resourceMethod : methods) {
            if (InterceptorExecutor.executeMethodLevelResponseInterceptors(request, response, resourceMethod)) continue;
            return false;
        }
        return true;
    }

    private static boolean executeGlobalRequestInterceptors(Request request, Response response, Collection<org.wso2.msf4j.interceptor.RequestInterceptor> requestInterceptors) {
        if (requestInterceptors == null) {
            return true;
        }
        for (org.wso2.msf4j.interceptor.RequestInterceptor interceptor : requestInterceptors) {
            if (InterceptorExecutor.executeRequestInterceptor(interceptor, request, response)) continue;
            return false;
        }
        return true;
    }

    private static boolean executeGlobalResponseInterceptors(Request request, Response response, Collection<org.wso2.msf4j.interceptor.ResponseInterceptor> responseInterceptors) {
        if (responseInterceptors == null) {
            return true;
        }
        for (org.wso2.msf4j.interceptor.ResponseInterceptor interceptor : responseInterceptors) {
            if (InterceptorExecutor.executeResponseInterceptor(interceptor, request, response)) continue;
            return false;
        }
        return true;
    }

    private static boolean executeNonGlobalRequestInterceptors(Request request, Response response, Collection<Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor>> classes) throws InterceptorException {
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        if (classes == null) {
            return true;
        }
        for (Class<? extends org.wso2.msf4j.interceptor.RequestInterceptor> requestInterceptorClass : classes) {
            org.wso2.msf4j.interceptor.RequestInterceptor interceptor;
            try {
                interceptor = requestInterceptorClass.cast(ReflectionUtils.createInstanceFromClass(requestInterceptorClass, parameterTypes, arguments));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new InterceptorException("Error occurred when creating an instance type of the interceptor class " + requestInterceptorClass, e);
            }
            if (InterceptorExecutor.executeRequestInterceptor(interceptor, request, response)) continue;
            return false;
        }
        return true;
    }

    private static boolean executeNonGlobalResponseInterceptors(Request request, Response response, Collection<Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor>> classes) throws InterceptorException {
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        if (classes == null) {
            return true;
        }
        for (Class<? extends org.wso2.msf4j.interceptor.ResponseInterceptor> responseInterceptorClass : classes) {
            org.wso2.msf4j.interceptor.ResponseInterceptor interceptor;
            try {
                interceptor = responseInterceptorClass.cast(ReflectionUtils.createInstanceFromClass(responseInterceptorClass, parameterTypes, arguments));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new InterceptorException("Error occurred when creating an instance type of the interceptor class " + responseInterceptorClass, e);
            }
            if (InterceptorExecutor.executeResponseInterceptor(interceptor, request, response)) continue;
            return false;
        }
        return true;
    }

    private static boolean executeRequestInterceptor(org.wso2.msf4j.interceptor.RequestInterceptor interceptor, Request request, Response response) {
        try {
            return interceptor.interceptRequest(request, response);
        }
        catch (Exception e) {
            return interceptor.onRequestInterceptionError(request, response, e);
        }
    }

    private static boolean executeResponseInterceptor(org.wso2.msf4j.interceptor.ResponseInterceptor interceptor, Request request, Response response) {
        try {
            return interceptor.interceptResponse(request, response);
        }
        catch (Exception e) {
            return interceptor.onResponseInterceptionError(request, response, e);
        }
    }
}

