/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contract.websocket;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.transport.http.netty.contract.config.SslConfiguration;

public class WebSocketClientConnectorConfig
extends SslConfiguration {
    private final String remoteAddress;
    private List<String> subProtocols;
    private int idleTimeoutInSeconds;
    private boolean autoRead;
    private final HttpHeaders headers;
    private int maxFrameSize = 65536;
    private boolean webSocketCompressionEnabled;

    public WebSocketClientConnectorConfig(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.headers = new DefaultHttpHeaders();
        this.setScheme("wss".equals(URI.create(remoteAddress).getScheme()) ? "https" : "http");
    }

    public String getSubProtocolsAsCSV() {
        if (this.subProtocols == null) {
            return null;
        }
        String subProtocolsAsCSV = "";
        for (String subProtocol : this.subProtocols) {
            subProtocolsAsCSV = subProtocolsAsCSV.concat(subProtocol + ",");
        }
        subProtocolsAsCSV = subProtocolsAsCSV.substring(0, subProtocolsAsCSV.length() - 1);
        return subProtocolsAsCSV;
    }

    public void setSubProtocols(String[] subProtocols) {
        if (subProtocols == null || subProtocols.length == 0) {
            this.subProtocols = null;
            return;
        }
        this.subProtocols = Arrays.asList(subProtocols);
    }

    public boolean isAutoRead() {
        return this.autoRead;
    }

    public void setAutoRead(boolean autoRead) {
        this.autoRead = autoRead;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void addHeaders(Map<String, String> headers) {
        headers.forEach(this.headers::add);
    }

    public void addHeader(String key, String value) {
        this.headers.add(key, (Object)value);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean containsHeader(String key) {
        return this.headers.contains(key);
    }

    public int getIdleTimeoutInMillis() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInMillis(int idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public boolean isWebSocketCompressionEnabled() {
        return this.webSocketCompressionEnabled;
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }
}

