/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ocsp.OcspClientHandler;
import java.math.BigInteger;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.RevocationVerificationManager;

public class OCSPStaplingHandler
extends OcspClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPStaplingHandler.class);

    public OCSPStaplingHandler(ReferenceCountedOpenSslEngine engine) {
        super(engine);
    }

    @Override
    protected boolean verify(ChannelHandlerContext ctx, ReferenceCountedOpenSslEngine engine) throws Exception {
        byte[] staple = engine.getOcspResponse();
        if (staple == null) {
            RevocationVerificationManager revocationVerifier = new RevocationVerificationManager(50, 15);
            return revocationVerifier.verifyRevocationStatus(engine.getSession().getPeerCertificateChain());
        }
        OCSPResp response = new OCSPResp(staple);
        if (response.getStatus() != 0) {
            return false;
        }
        SSLSession session = engine.getSession();
        X509Certificate[] chain = session.getPeerCertificateChain();
        BigInteger certSerial = chain[0].getSerialNumber();
        BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
        SingleResp singleResp = basicResponse.getResponses()[0];
        CertificateStatus status = singleResp.getCertStatus();
        BigInteger ocspSerial = singleResp.getCertID().getSerialNumber();
        if (LOG.isDebugEnabled()) {
            String message = "OCSP status of " + ctx.channel().remoteAddress() + "\n  Status: " + (status == CertificateStatus.GOOD ? "Good" : status) + "\n  This Update: " + singleResp.getThisUpdate() + "\n  Next Update: " + singleResp.getNextUpdate() + "\n  Cert Serial: " + certSerial + "\n  OCSP Serial: " + ocspSerial;
            LOG.debug(message);
        }
        return status == CertificateStatus.GOOD && certSerial.equals(ocspSerial);
    }
}

