/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.BackPressureObservable;
import org.wso2.transport.http.netty.message.DefaultBackPressureObservable;

public class BackPressureHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BackPressureHandler.class);
    private final BackPressureObservable backPressureObservable = new DefaultBackPressureObservable();

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (ctx.channel().isWritable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/1.1 channel writable in thread {} ", (Object)Thread.currentThread().getName());
            }
            this.backPressureObservable.notifyWritable();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/1.1 channel inactive and notifyWritable in thread {} ", (Object)Thread.currentThread().getName());
        }
        if (this.backPressureObservable.getListener() != null) {
            this.backPressureObservable.notifyWritable();
        }
        ctx.fireChannelInactive();
    }

    public BackPressureObservable getBackPressureObservable() {
        return this.backPressureObservable;
    }
}

