/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.util.Map;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ServerConnectorErrorHandler;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;

public abstract class ServerConnector {
    protected String id;
    protected State state = State.UNINITIALIZED;
    protected Map<String, String> properties;
    protected ServerConnectorErrorHandler errorHandler;

    public ServerConnector(String id, Map<String, String> properties) {
        this.id = id;
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public abstract void setMessageProcessor(CarbonMessageProcessor var1);

    public void setServerConnectorErrorHandler(ServerConnectorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ServerConnectorErrorHandler getServerConnectorErrorHandler() {
        return this.errorHandler;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public void initConnector() throws ServerConnectorException {
        if (!this.state.equals((Object)State.UNINITIALIZED) && !this.state.equals((Object)State.IN_MAINTENANCE)) {
            throw new IllegalStateException("Cannot initialize connector " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.init();
        this.state = State.INITIALIZED;
    }

    protected abstract void init() throws ServerConnectorException;

    public void destroyConnector() throws ServerConnectorException {
        if (!this.state.equals((Object)State.INITIALIZED)) {
            throw new IllegalStateException("Cannot destroy connector " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.destroy();
        this.state = State.UNINITIALIZED;
    }

    protected abstract void destroy() throws ServerConnectorException;

    public void beginConnectorMaintenance() throws ServerConnectorException {
        if (!this.state.equals((Object)State.INITIALIZED)) {
            throw new IllegalStateException("Cannot put connector " + this.id + " into maintenance. Current state: " + (Object)((Object)this.state));
        }
        this.beginMaintenance();
        this.state = State.IN_MAINTENANCE;
    }

    protected abstract void beginMaintenance() throws ServerConnectorException;

    public void endConnectorMaintenance() throws ServerConnectorException {
        if (!this.state.equals((Object)State.IN_MAINTENANCE)) {
            throw new IllegalStateException("Cannot end maintenance of connector " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.endMaintenance();
        this.state = State.INITIALIZED;
    }

    protected abstract void endMaintenance() throws ServerConnectorException;

    public abstract void start() throws ServerConnectorException;

    public abstract void stop() throws ServerConnectorException;

    public static enum State {
        UNINITIALIZED,
        INITIALIZED,
        IN_MAINTENANCE;


        public String toString() {
            return this.name();
        }
    }
}

