/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.ResponseCompleted;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final HandlerExecutor handlerExecutor;
    private final ServerConnectorFuture serverConnectorFuture;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final SourceHandler sourceHandler;
    private final HttpCarbonMessage inboundRequestMsg;
    private final float httpVersion;

    ReceivingEntityBody(ListenerReqRespStateManager listenerReqRespStateManager, HttpCarbonMessage inboundRequestMsg, SourceHandler sourceHandler, float httpVersion) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.inboundRequestMsg = inboundRequestMsg;
        this.sourceHandler = sourceHandler;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.serverConnectorFuture = sourceHandler.getServerConnectorFuture();
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        if (inboundRequestEntityBody instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)inboundRequestEntityBody;
            try {
                this.inboundRequestMsg.addHttpContent(httpContent);
                if (Util.isLastHttpContent(httpContent)) {
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtSourceRequestSending(this.inboundRequestMsg);
                    }
                    if (this.isDiffered(this.inboundRequestMsg)) {
                        this.serverConnectorFuture.notifyHttpListener(this.inboundRequestMsg);
                    }
                    this.inboundRequestMsg.setLastHttpContentArrived();
                    this.sourceHandler.resetInboundRequestMsg();
                    this.listenerReqRespStateManager.state = new EntityBodyReceived(this.listenerReqRespStateManager, this.sourceHandler, this.httpVersion);
                }
            }
            catch (RuntimeException ex) {
                httpContent.release();
                this.inboundRequestMsg.notifyContentFailure(ex);
                LOG.warn("Response already received before completing the inbound request {}", (Object)ex.getMessage());
            }
        }
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        if (Util.getHttpResponseStatus(outboundResponseMsg).code() != HttpResponseStatus.CONTINUE.code()) {
            StateUtil.respondToIncompleteRequest(this.sourceHandler.getInboundChannelContext().channel(), outboundResponseListener, this.listenerReqRespStateManager, outboundResponseMsg, httpContent, "Remote client closed the connection while reading inbound request entity body");
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Remote client closed the connection while reading inbound request entity body");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        ByteBuf responseBody = Unpooled.copiedBuffer("Idle timeout triggered while reading inbound request entity body", CharsetUtil.UTF_8);
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, responseBody, responseBody.readableBytes(), this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener(channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
            StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Idle timeout triggered while reading inbound request entity body");
        });
        this.listenerReqRespStateManager.state = new ResponseCompleted(this.listenerReqRespStateManager, this.sourceHandler, this.inboundRequestMsg);
        return outboundRespFuture;
    }

    private boolean isDiffered(HttpCarbonMessage sourceReqCmsg) {
        return sourceReqCmsg.getProperty("httpResource") != null;
    }
}

