/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.InboundMessageHolder;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.Expect100ContinueHeaderReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final Http2SourceHandler http2SourceHandler;
    private final Http2MessageStateContext http2MessageStateContext;

    public ReceivingHeaders(Http2SourceHandler http2SourceHandler, Http2MessageStateContext http2MessageStateContext) {
        this.http2SourceHandler = http2SourceHandler;
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws Http2Exception {
        int streamId = headersFrame.getStreamId();
        if (headersFrame.isEndOfStream()) {
            HttpCarbonMessage sourceReqCMsg;
            InboundMessageHolder inboundMessageHolder = this.http2SourceHandler.getStreamIdRequestMap().get(streamId);
            HttpCarbonMessage httpCarbonMessage = sourceReqCMsg = inboundMessageHolder != null ? inboundMessageHolder.getInboundMsg() : null;
            if (headersFrame.getHeaders().contains(":method")) {
                sourceReqCMsg = this.setupHttp2CarbonMsg(headersFrame.getHeaders(), streamId);
                sourceReqCMsg.addHttpContent(new DefaultLastHttpContent());
                this.initializeDataEventListeners(ctx, streamId, sourceReqCMsg);
                sourceReqCMsg.setHttp2MessageStateContext(this.http2MessageStateContext);
            }
            this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
        } else {
            HttpCarbonMessage sourceReqCMsg = this.setupHttp2CarbonMsg(headersFrame.getHeaders(), streamId);
            sourceReqCMsg.setHttp2MessageStateContext(this.http2MessageStateContext);
            this.initializeDataEventListeners(ctx, streamId, sourceReqCMsg);
            if (Util.is100ContinueRequest(sourceReqCMsg)) {
                this.http2MessageStateContext.setListenerState(new Expect100ContinueHeaderReceived(this.http2MessageStateContext));
            } else {
                this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
            }
        }
    }

    private void initializeDataEventListeners(ChannelHandlerContext ctx, int streamId, HttpCarbonMessage sourceReqCMsg) {
        InboundMessageHolder inboundMsgHolder = new InboundMessageHolder(sourceReqCMsg);
        this.http2SourceHandler.getStreamIdRequestMap().put(streamId, inboundMsgHolder);
        this.http2SourceHandler.getHttp2ServerChannel().getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, streamId));
        Http2StateUtil.notifyRequestListener(this.http2SourceHandler, inboundMsgHolder, streamId);
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) {
        LOG.warn("writeOutboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, true, true);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        StateUtil.handleIncompleteInboundMessage(http2OutboundRespListener.getInboundRequestMsg(), "Remote client closed the connection while reading inbound request headers");
    }

    private HttpCarbonMessage setupHttp2CarbonMsg(Http2Headers http2Headers, int streamId) throws Http2Exception {
        return Http2StateUtil.setupCarbonRequest(Util.createHttpRequestFromHttp2Headers(http2Headers, streamId), this.http2SourceHandler, streamId);
    }
}

