/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.contractimpl.sender.HttpClientChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;

public class SslHandshakeCompletionHandlerForClient
extends ChannelInboundHandlerAdapter {
    private ConnectionAvailabilityFuture connectionAvailabilityFuture;
    private HttpClientChannelInitializer httpClientChannelInitializer;
    private TargetHandler targetHandler;
    private SSLEngine sslEngine;

    SslHandshakeCompletionHandlerForClient(ConnectionAvailabilityFuture connectionAvailabilityFuture, HttpClientChannelInitializer httpClientChannelInitializer, TargetHandler targetHandler, SSLEngine sslEngine) {
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        this.httpClientChannelInitializer = httpClientChannelInitializer;
        this.targetHandler = targetHandler;
        this.sslEngine = sslEngine;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            ctx.pipeline().remove(this);
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess()) {
                if (!this.httpClientChannelInitializer.getSslConfig().isDisableSsl()) {
                    try {
                        X509Certificate endUserCert = (X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0];
                        endUserCert.checkValidity(new Date());
                    }
                    catch (CertificateExpiredException e) {
                        this.connectionAvailabilityFuture.notifyFailure(new SSLException("Certificate expired : " + e.getMessage()));
                        ctx.close();
                    }
                }
                this.httpClientChannelInitializer.configureHttpPipeline(ctx.pipeline(), this.targetHandler);
                this.connectionAvailabilityFuture.notifySuccess("http");
            } else {
                Throwable cause = this.getTheRootCause(event);
                this.connectionAvailabilityFuture.notifyFailure(cause);
            }
        }
    }

    private Throwable getTheRootCause(SslHandshakeCompletionEvent event) {
        Throwable cause;
        for (cause = event.cause(); cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
        }
        return cause;
    }
}

