/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketFrameType;
import org.wso2.transport.http.netty.contractimpl.listener.WebSocketMessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketInboundFrameHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketUtil;

public class DefaultWebSocketConnection
implements WebSocketConnection {
    private final ChannelHandlerContext ctx;
    private final WebSocketInboundFrameHandler frameHandler;
    private final boolean secure;
    private final InetSocketAddress localAddress;
    private WebSocketMessageQueueHandler webSocketMessageQueueHandler;
    private WebSocketFrameType continuationFrameType;
    private boolean closeFrameSent;
    private int closeInitiatedStatusCode;
    private String id;
    private String negotiatedSubProtocol;

    public DefaultWebSocketConnection(ChannelHandlerContext ctx, WebSocketInboundFrameHandler frameHandler, WebSocketMessageQueueHandler webSocketMessageQueueHandler, boolean secure, String negotiatedSubProtocol) {
        this.ctx = ctx;
        this.id = WebSocketUtil.getChannelId(ctx);
        this.frameHandler = frameHandler;
        this.webSocketMessageQueueHandler = webSocketMessageQueueHandler;
        this.secure = secure;
        this.localAddress = (InetSocketAddress)ctx.channel().localAddress();
        this.negotiatedSubProtocol = negotiatedSubProtocol;
    }

    @Override
    public String getChannelId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.ctx.channel().isOpen();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public String getHost() {
        return this.localAddress.getHostName();
    }

    @Override
    public int getPort() {
        return this.localAddress.getPort();
    }

    @Override
    public String getNegotiatedSubProtocol() {
        return this.negotiatedSubProtocol;
    }

    @Override
    public void readNextFrame() {
        this.webSocketMessageQueueHandler.readNextFrame();
    }

    @Override
    public void startReadingFrames() {
        ChannelPipeline pipeline = this.ctx.pipeline();
        if (pipeline.get("MESSAGE_QUEUE_HANDLER") != null) {
            this.ctx.pipeline().remove("MESSAGE_QUEUE_HANDLER");
        }
        this.ctx.channel().config().setAutoRead(true);
    }

    @Override
    public void stopReadingFrames() {
        this.ctx.channel().config().setAutoRead(false);
        ChannelPipeline pipeline = this.ctx.pipeline();
        if (pipeline.get("MESSAGE_QUEUE_HANDLER") == null) {
            this.ctx.pipeline().addBefore("WEBSOCKET_FRAME_HANDLER", "MESSAGE_QUEUE_HANDLER", this.webSocketMessageQueueHandler);
        }
    }

    @Override
    public ChannelFuture pushText(String text) {
        return this.pushText(text, true);
    }

    @Override
    public ChannelFuture pushText(String text, boolean finalFrame) {
        if (this.continuationFrameType == WebSocketFrameType.BINARY) {
            throw new IllegalStateException("Cannot interrupt WebSocket binary frame continuation");
        }
        if (this.closeFrameSent) {
            throw new IllegalStateException("Close frame already sent. Cannot push text data!");
        }
        if (this.continuationFrameType != null) {
            if (finalFrame) {
                this.continuationFrameType = null;
            }
            return this.ctx.writeAndFlush(new ContinuationWebSocketFrame(finalFrame, 0, text));
        }
        if (!finalFrame) {
            this.continuationFrameType = WebSocketFrameType.TEXT;
        }
        return this.ctx.writeAndFlush(new TextWebSocketFrame(finalFrame, 0, text));
    }

    @Override
    public ChannelFuture pushBinary(ByteBuffer data) {
        return this.pushBinary(data, true);
    }

    @Override
    public ChannelFuture pushBinary(ByteBuffer data, boolean finalFrame) {
        if (this.continuationFrameType == WebSocketFrameType.TEXT) {
            throw new IllegalStateException("Cannot interrupt WebSocket text frame continuation");
        }
        if (this.closeFrameSent) {
            throw new IllegalStateException("Close frame already sent. Cannot push binary data.");
        }
        if (this.continuationFrameType != null) {
            if (finalFrame) {
                this.continuationFrameType = null;
            }
            return this.ctx.writeAndFlush(new ContinuationWebSocketFrame(finalFrame, 0, this.getNettyByteBuf(data)));
        }
        if (!finalFrame) {
            this.continuationFrameType = WebSocketFrameType.BINARY;
        }
        return this.ctx.writeAndFlush(new BinaryWebSocketFrame(finalFrame, 0, this.getNettyByteBuf(data)));
    }

    @Override
    public ChannelFuture ping(ByteBuffer data) {
        return this.ctx.writeAndFlush(new PingWebSocketFrame(this.getNettyByteBuf(data)));
    }

    @Override
    public ChannelFuture pong(ByteBuffer data) {
        return this.ctx.writeAndFlush(new PongWebSocketFrame(this.getNettyByteBuf(data)));
    }

    @Override
    public ChannelFuture initiateConnectionClosure(int statusCode, String reason) {
        return this.initiateConnectionClosure(new CloseWebSocketFrame(statusCode, reason));
    }

    @Override
    public ChannelFuture initiateConnectionClosure() {
        return this.initiateConnectionClosure(new CloseWebSocketFrame());
    }

    private ChannelFuture initiateConnectionClosure(CloseWebSocketFrame closeWebSocketFrame) {
        this.handleCloseFrameSent();
        this.closeInitiatedStatusCode = closeWebSocketFrame.statusCode();
        this.closeInitiatedStatusCode = this.closeInitiatedStatusCode == -1 ? 1005 : this.closeInitiatedStatusCode;
        ChannelPromise closePromise = this.ctx.newPromise();
        this.ctx.writeAndFlush(closeWebSocketFrame).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            this.frameHandler.setClosePromise(closePromise);
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                this.ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> closePromise.setFailure(cause)));
            }
        }));
        return closePromise;
    }

    @Override
    public ChannelFuture finishConnectionClosure(int statusCode, String reason) {
        return this.finishConnectionClosure(new CloseWebSocketFrame(statusCode, reason));
    }

    @Override
    public ChannelFuture finishConnectionClosure() {
        return this.finishConnectionClosure(new CloseWebSocketFrame());
    }

    private ChannelFuture finishConnectionClosure(CloseWebSocketFrame closeWebSocketFrame) {
        if (!this.frameHandler.isCloseFrameReceived()) {
            throw new IllegalStateException("Cannot finish a connection closure without receiving a close frame");
        }
        ChannelPromise channelPromise = this.ctx.newPromise();
        this.ctx.writeAndFlush(closeWebSocketFrame).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                this.ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> channelPromise.setFailure(cause)));
                return;
            }
            this.ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> channelPromise.setSuccess()));
        }));
        return channelPromise;
    }

    @Override
    public ChannelFuture terminateConnection() {
        this.frameHandler.setCloseInitialized(true);
        return this.ctx.close();
    }

    @Override
    public ChannelFuture terminateConnection(int statusCode, String reason) {
        this.handleCloseFrameSent();
        ChannelPromise closePromise = this.ctx.newPromise();
        this.ctx.writeAndFlush(new CloseWebSocketFrame(statusCode, reason)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeFuture -> {
            this.frameHandler.setCloseInitialized(true);
            Throwable writeCause = writeFuture.cause();
            if (!writeFuture.isSuccess() && writeCause != null) {
                closePromise.setFailure(writeCause);
                this.ctx.close();
                return;
            }
            this.ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> {
                Throwable closeCause = closeFuture.cause();
                if (!closeFuture.isSuccess() && closeCause != null) {
                    closePromise.setFailure(closeCause);
                } else {
                    closePromise.setSuccess();
                }
            }));
        }));
        return closePromise;
    }

    private void handleCloseFrameSent() {
        if (this.closeFrameSent) {
            throw new IllegalStateException("Close frame already sent. Cannot send close frame again.");
        }
        this.closeFrameSent = true;
    }

    int getCloseInitiatedStatusCode() {
        return this.closeInitiatedStatusCode;
    }

    private ByteBuf getNettyByteBuf(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer(buffer);
    }
}

