/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;

public class EntityBodyReceived
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final Http2TargetHandler http2TargetHandler;
    private Http2TargetHandler.Http2RequestWriter http2RequestWriter;
    private OutboundMsgHolder outboundMsgHolder;

    EntityBodyReceived(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        if (http2RequestWriter != null) {
            this.http2RequestWriter = http2RequestWriter;
            this.outboundMsgHolder = http2RequestWriter.getOutboundMsgHolder();
        }
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        if (this.http2RequestWriter != null && this.outboundMsgHolder != null) {
            this.outboundMsgHolder.getRequest().setIoException(new IOException("Inbound response message already received"));
            http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
            http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, new DefaultLastHttpContent(), http2MessageStateContext);
            http2MessageStateContext.setSenderState(new EntityBodyReceived(this.http2TargetHandler, this.http2RequestWriter));
        }
        Http2StateUtil.releaseContent(httpContent);
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        LOG.warn("readInboundResponseBody is not a dependant action of this state");
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext ctx, int streamId) {
        LOG.warn("handleStreamTimeout {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel is closed");
        }
    }
}

