# WSO2 Microservice Framework for Java (MSF4J) Distribution

WSO2 MSF4J is a lightweight high performance framework for implementing microservices in Java. MSF4J 
distribution contains the [msf4j-all.jar](../msf4j-all) file and the samples.


## Running & Installation

Prerequisites: JDK 1.8 and Maven 3.1.x.

You can simply add the msf4j-all-*.jar file in this distribution to your classpath and start writing your
microservice. If you have Maven installed, you could navigate to the relevant samples in this distribution and
run 'mvn clean package' to build the samples. Please follow the instructions in the README files for detailed
instructions about the samples.

We also have a Maven archetype called msf4j-microservice, and you can create your project using that archetype.
Please see https://github.com/wso2/msf4j/tree/master/archetypes for more details.

For key concepts, see https://docs.wso2.com/display/MSF4J100/Key+Concepts#KeyConcepts


## Support

WSO2 Inc. offers a variety of development and production support
programs, ranging from Web-based support up through normal business
hours, to premium 24x7 phone support.

For additional support information please refer to http://wso2.com/support

For more information on WSO2 Microservices Framework for Java (MSF4J),
visit project Home Page (http://wso2.com/products/microservices-framework-for-java/)


## Contact Us

WSO2 MSF4J developers can be contacted via the following mailing lists.
    - Development:  dev@wso2.org
    - Architecture: architecture@wso2.org

Alternatively, questions can also be raised in the stackoverflow forum
http://stackoverflow.com/questions/tagged/wso2


## How To Contribute

You can find comprehensive instructions on how to contribute from the Getting Involved guide
http://docs.wso2.com/microservices-framework-for-java/Get+Involved


## For Further Details

- http://docs.wso2.org/microservices-framework-for-java
- https://github.com/wso2/msf4j


---------------------------------------------------------------------------
(c) Copyright 2017 WSO2 Inc.
