/*
 *  Copyright (c) 2017, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  WSO2 Inc. licenses this file to you under the Apache License,
 *  Version 2.0 (the "License"); you may not use this file except
 *  in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.msf4j.samples.interceptor.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.ResponseInterceptor;

/**
 * HTTP response logging class.
 * Please note that the @Component annotation is only required in OSGI mode
 */
public class HTTPResponseLogger implements ResponseInterceptor {

    private static final Logger log = LoggerFactory.getLogger(HTTPResponseLogger.class);

    @Override
    public boolean interceptResponse(Request request, Response response) throws Exception {
        log.info("Logging HTTP response { Status code: {} }", response.getStatusCode());
        return true;
    }
}
