/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ServerProcess;
import org.wso2.diagnostics.utils.JmxtermExecutor;

public class MetricsSnapshot
implements ActionExecutor {
    private static final Logger log = LogManager.getLogger(MetricsSnapshot.class);
    private final String pid = ServerProcess.getProcessId();

    @Override
    public void execute(String folderPath) {
        if (new File(folderPath).exists()) {
            String filepath = folderPath + "/metrics-snapshot.txt";
            try {
                FileWriter writer = new FileWriter(filepath);
                writer.write(this.getServerMetrics());
                writer.close();
                log.info("MetricsSnapshot executed successfully.");
            }
            catch (IOException e) {
                log.error("Unable to do write server information to file.");
            }
        }
    }

    public String getServerMetrics() {
        Object metrics = "";
        metrics = (String)metrics + "Server Metrics\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + "Memory Usage: " + JmxtermExecutor.getMemoryUsage(this.pid) + "%\n";
        metrics = (String)metrics + "CPU Usage: " + JmxtermExecutor.getCpuUsage(this.pid) + "%\n";
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Listener Metrics\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + "Active Connections: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "ActiveConnections") + "\n";
        metrics = (String)metrics + "LastSecondConnections: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "LastSecondConnections") + "\n";
        metrics = (String)metrics + "Last5SecondConnections: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "Last5SecondConnections") + "\n";
        metrics = (String)metrics + "Last15SecondConnections: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "Last15SecondConnections") + "\n";
        metrics = (String)metrics + "LastMinuteConnections: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "LastMinuteConnections") + "\n";
        metrics = (String)metrics + "LastSecondRequests: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "LastSecondRequests") + "\n";
        metrics = (String)metrics + "Last15SecondRequests: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "Last15SecondRequests") + "\n";
        metrics = (String)metrics + "LastMinuteRequests: " + JmxtermExecutor.getAttributeValue("http-listener", this.pid, "LastMinuteRequests") + "\n";
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Listener Metrics\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + "Active Connections: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "ActiveConnections") + "\n";
        metrics = (String)metrics + "LastSecondConnections: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "LastSecondConnections") + "\n";
        metrics = (String)metrics + "Last5SecondConnections: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "Last5SecondConnections") + "\n";
        metrics = (String)metrics + "Last15SecondConnections: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "Last15SecondConnections") + "\n";
        metrics = (String)metrics + "LastMinuteConnections: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "LastMinuteConnections") + "\n";
        metrics = (String)metrics + "LastSecondRequests: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "LastSecondRequests") + "\n";
        metrics = (String)metrics + "Last15SecondRequests: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "Last15SecondRequests") + "\n";
        metrics = (String)metrics + "LastMinuteRequests: " + JmxtermExecutor.getAttributeValue("https-listener", this.pid, "LastMinuteRequests") + "\n";
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Sender Metrics\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + "Active Connections: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "ActiveConnections") + "\n";
        metrics = (String)metrics + "LastSecondConnections: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "LastSecondConnections") + "\n";
        metrics = (String)metrics + "Last5SecondConnections: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "Last5SecondConnections") + "\n";
        metrics = (String)metrics + "Last15SecondConnections: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "Last15SecondConnections") + "\n";
        metrics = (String)metrics + "LastMinuteConnections: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "LastMinuteConnections") + "\n";
        metrics = (String)metrics + "LastSecondRequests: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "LastSecondRequests") + "\n";
        metrics = (String)metrics + "Last15SecondRequests: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "Last15SecondRequests") + "\n";
        metrics = (String)metrics + "LastMinuteRequests: " + JmxtermExecutor.getAttributeValue("http-sender", this.pid, "LastMinuteRequests") + "\n";
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Sender Metrics\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + "Active Connections: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "ActiveConnections") + "\n";
        metrics = (String)metrics + "LastSecondConnections: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "LastSecondConnections") + "\n";
        metrics = (String)metrics + "Last5SecondConnections: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "Last5SecondConnections") + "\n";
        metrics = (String)metrics + "Last15SecondConnections: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "Last15SecondConnections") + "\n";
        metrics = (String)metrics + "LastMinuteConnections: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "LastMinuteConnections") + "\n";
        metrics = (String)metrics + "LastSecondRequests: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "LastSecondRequests") + "\n";
        metrics = (String)metrics + "Last15SecondRequests: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "Last15SecondRequests") + "\n";
        metrics = (String)metrics + "LastMinuteRequests: " + JmxtermExecutor.getAttributeValue("https-sender", this.pid, "LastMinuteRequests") + "\n";
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Listener RequestMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("http-listener", this.pid, "RequestSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Listener ResponseMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("http-listener", this.pid, "ResponseSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Listener RequestMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("https-listener", this.pid, "RequestSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Listener ResponseMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("https-listener", this.pid, "ResponseSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Sender RequestMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("http-sender", this.pid, "RequestSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Http Sender ResponseMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("http-sender", this.pid, "ResponseSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Sender RequestMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("https-sender", this.pid, "RequestSizesMap");
        metrics = (String)metrics + "\n";
        metrics = (String)metrics + "Https Sender ResponseMap\n";
        metrics = (String)metrics + "==============\n";
        metrics = (String)metrics + JmxtermExecutor.getMessageSizes("https-sender", this.pid, "ResponseSizesMap");
        metrics = (String)metrics + "\n";
        return metrics;
    }
}

