/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.utils.ConfigMapHolder;
import org.wso2.diagnostics.utils.FileUtils;

public class ServerInfo
implements ActionExecutor {
    private static final Logger log = LogManager.getLogger(ServerInfo.class);
    private Map<String, Object> configuration = ConfigMapHolder.getInstance().getConfigMap();

    @Override
    public void execute(String folderPath) {
        if (new File(folderPath).exists()) {
            String filepath = folderPath + "/server-info.txt";
            try {
                FileWriter writer = new FileWriter(filepath);
                writer.write(this.getServerInfo());
                writer.close();
            }
            catch (IOException e) {
                log.error("Unable to do write server information to file.");
            }
        }
        this.copyDeploymentToml(folderPath);
        this.copyLogsFolder(folderPath);
        this.copyDiagnosticLog(folderPath);
        log.info("ServerInfo executed successfully.");
    }

    public String getServerInfo() {
        Object serverInfo = "";
        serverInfo = (String)serverInfo + "Server name: " + ConfigMapHolder.getInstance().getConfigMap().get("server_configuration.server_name") + "\n";
        serverInfo = (String)serverInfo + "Version: " + ConfigMapHolder.getInstance().getConfigMap().get("server_configuration.server_version") + "\n";
        serverInfo = (String)serverInfo + "Update Level: " + this.getServerUpdateInfo() + "\n";
        serverInfo = (String)serverInfo + "Java Version: " + System.getProperty("java.version") + "\n";
        serverInfo = (String)serverInfo + "Java Home: " + System.getProperty("java.home") + "\n";
        serverInfo = (String)serverInfo + "OS Name: " + System.getProperty("os.name") + "\n";
        serverInfo = (String)serverInfo + "OS Version: " + System.getProperty("os.version") + "\n";
        serverInfo = (String)serverInfo + "OS Architecture: " + System.getProperty("os.arch") + "\n";
        serverInfo = (String)serverInfo + "Diagnostic App Home: " + System.getProperty("app.home") + "\n";
        return serverInfo;
    }

    private void copyDeploymentToml(String folderpath) {
        String deploymentToml = System.getProperty("app.home") + File.separator + this.configuration.get("server_configuration.deployment_toml_path");
        File file = new File(deploymentToml);
        if (file.exists()) {
            FileUtils.copyFile(deploymentToml, folderpath + "/deployment.toml");
        }
    }

    private void copyLogsFolder(String folderpath) {
        String logsFolder = System.getProperty("app.home") + File.separator + this.configuration.get("server_configuration.logs_directory");
        File file = new File(logsFolder);
        if (file.exists()) {
            FileUtils.zipFolder(logsFolder, folderpath + "/logs.zip");
        }
    }

    private void copyDiagnosticLog(String folderpath) {
        String deploymentToml = System.getProperty("app.home") + File.separator + this.configuration.get("server_configuration.diagnostic_log_file_path");
        File file = new File(deploymentToml);
        if (file.exists()) {
            FileUtils.copyFile(deploymentToml, folderpath + "/diagnostics.log");
        }
    }

    private String getServerUpdateInfo() {
        JsonObject configJsonObj;
        File file;
        String configJson = System.getProperty("app.home") + File.separator + this.configuration.get("server_configuration.updates_config_path");
        if (log.isDebugEnabled()) {
            log.debug("Config JSON path: " + configJson);
        }
        if ((file = new File(configJson)).exists() && (configJsonObj = ServerInfo.readJsonObject(configJson)) != null) {
            if (!configJsonObj.has("update-level")) {
                log.info("Field 'update-level' not found in the update JSON.");
            } else {
                String updateLevel = configJsonObj.get("update-level").getAsString();
                log.info("Update level: " + updateLevel);
                return updateLevel;
            }
        }
        return null;
    }

    private static JsonObject readJsonObject(String jsonFilePath) {
        try {
            JsonObject jsonObject = JsonParser.parseReader((Reader)new FileReader(jsonFilePath)).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException e) {
            log.info("Updates info file not found.");
            return null;
        }
    }
}

