/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ActionExecutorFactory;
import org.wso2.diagnostics.postexecutor.ZipFileExecutor;
import org.wso2.diagnostics.utils.CommonUtils;
import org.wso2.diagnostics.utils.FileUtils;
import org.wso2.diagnostics.utils.JmxtermExecutor;

public class MemoryWatcher
extends Thread {
    private static final Logger log = LogManager.getLogger(MemoryWatcher.class);
    private final int retryCount;
    private final double threshold;
    private int count = 0;
    private final String pid;
    private long lastCountUpdatedTime;

    public MemoryWatcher(String pid, double threshold, int retryCount) {
        this.pid = pid;
        this.threshold = threshold;
        this.retryCount = retryCount;
        this.lastCountUpdatedTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Memory watcher thread executing for pid: " + this.pid + ", threshold: " + this.threshold + ", retry count: " + this.retryCount + ", count: " + this.count + ", last count updated time: " + this.lastCountUpdatedTime + ", current time: " + System.currentTimeMillis());
        }
        double memoryUsage = JmxtermExecutor.getMemoryUsage(this.pid);
        log.debug("Memory usage: " + memoryUsage + "%");
        if (memoryUsage > this.threshold) {
            ++this.count;
            this.lastCountUpdatedTime = System.currentTimeMillis();
            log.info("Heap usage is above threshold. Heap usage: " + memoryUsage + ", Retry count: " + this.count);
        }
        if (this.count > this.retryCount) {
            log.debug("Memory usage is consistently above threshold. Executing memory watcher actions.");
            String tempFolderPath = FileUtils.createTimeStampFolder();
            String[] actionExecutors = CommonUtils.getActionExecutors("memory_watcher");
            if (actionExecutors != null) {
                for (String actionExecutor : actionExecutors) {
                    ActionExecutor executor;
                    if (log.isDebugEnabled()) {
                        log.debug("Executing action executor: " + actionExecutor);
                    }
                    if ((executor = ActionExecutorFactory.getActionExecutor(actionExecutor)) != null) {
                        executor.execute(tempFolderPath);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Action executor " + actionExecutor + " executed successfully.");
                        continue;
                    }
                    log.error("Action executor " + actionExecutor + " is not available.");
                }
            }
            ZipFileExecutor zipFileExecutor = new ZipFileExecutor();
            zipFileExecutor.execute(tempFolderPath);
            if (log.isDebugEnabled()) {
                log.debug("Zipping the folder " + tempFolderPath + " is successful.");
            }
            FileUtils.deleteFolder(tempFolderPath);
            if (log.isDebugEnabled()) {
                log.debug("Deleted the folder " + tempFolderPath + " successfully.");
            }
            this.count = 0;
            this.lastCountUpdatedTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastCountUpdatedTime > 3600000L) {
            this.count = 0;
        }
    }
}

