/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.jline;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclopsgroup.caff.token.TokenEvent;
import org.cyclopsgroup.caff.token.TokenEventHandler;
import org.cyclopsgroup.caff.token.ValueTokenizer;
import org.cyclopsgroup.jcli.ArgumentProcessor;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.jline.ArgumentsInspector;
import org.cyclopsgroup.jcli.spi.Option;
import org.cyclopsgroup.jcli.spi.ParsingContext;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class CliCompletor
implements Completer {
    private final ParsingContext context;
    private final AutoCompletable completable;
    private final ValueTokenizer tokenizer;

    private static List<String> filterList(List<String> list, String prefix) {
        if (Strings.isNullOrEmpty(prefix)) {
            return list;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String item : list) {
            if (!item.startsWith(prefix)) continue;
            results.add(item);
        }
        return results;
    }

    public CliCompletor(Object cliBean, ValueTokenizer tokenizer) {
        Preconditions.checkNotNull(cliBean, "Cli bean can't be null.");
        Preconditions.checkNotNull(tokenizer, "String tokenizer can't be null.");
        this.context = ArgumentProcessor.forType(cliBean.getClass()).createParsingContext();
        this.completable = cliBean instanceof AutoCompletable ? (AutoCompletable)cliBean : new AutoCompletable(){

            @Override
            public List<String> suggestArgument(String partialArgument) {
                return Collections.emptyList();
            }

            @Override
            public List<String> suggestOption(String optionName, String partialOption) {
                return Collections.emptyList();
            }
        };
        this.tokenizer = tokenizer;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> suggestions) {
        String command = line.line();
        ArgumentsInspector inspector = new ArgumentsInspector(this.context);
        final AtomicBoolean terminated = new AtomicBoolean(true);
        final AtomicInteger lastWordStart = new AtomicInteger(0);
        if (!Strings.isNullOrEmpty(command)) {
            final ArrayList args = new ArrayList();
            this.tokenizer.parse(command, new TokenEventHandler(){

                @Override
                public void handleEvent(TokenEvent ev) {
                    args.add(ev.getToken());
                    terminated.set(ev.isTerminated());
                    lastWordStart.set(ev.getStart());
                }
            });
            for (String arg : args) {
                inspector.consume(arg);
            }
            if (terminated.get()) {
                inspector.end();
            }
        }
        ArrayList<String> candidates = new ArrayList<String>();
        switch (inspector.getState()) {
            case READY: {
                for (Option o : inspector.getRemainingOptions()) {
                    candidates.add("-" + o.getName());
                }
                Collections.sort(candidates);
                candidates.addAll(this.suggestArguments(null));
                break;
            }
            case OPTION: 
            case LONG_OPTION: {
                candidates.addAll(this.suggestOptionNames(inspector, inspector.getCurrentValue()));
                break;
            }
            case OPTION_VALUE: {
                candidates.addAll(this.suggestOptionValue(inspector.getCurrentOption(), inspector.getCurrentValue()));
                break;
            }
            case ARGUMENT: {
                candidates.addAll(this.suggestArguments(inspector.getCurrentValue()));
            }
        }
        for (String candidate : candidates) {
            suggestions.add(new Candidate(this.tokenizer.escape(candidate)));
        }
    }

    private List<String> suggestArguments(String partialArgument) {
        List<String> results;
        if (Strings.isNullOrEmpty(partialArgument)) {
            results = this.completable.suggestArgument(null);
        } else {
            results = this.completable.suggestArgument(partialArgument);
            if (results == null) {
                results = CliCompletor.filterList(this.completable.suggestArgument(null), partialArgument);
            }
        }
        if (results == null) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList<String>(results);
            Collections.sort(results);
        }
        return results;
    }

    private List<String> suggestOptionNames(ArgumentsInspector inspector, String value) {
        ArrayList<String> results = new ArrayList<String>();
        for (Option o : inspector.getRemainingOptions()) {
            if (value.startsWith("--") && o.getLongName() != null && ("--" + o.getLongName()).startsWith(value)) {
                results.add("--" + o.getLongName());
                continue;
            }
            if (!value.startsWith("-") || !("-" + o.getName()).startsWith(value)) continue;
            results.add("-" + o.getName());
        }
        Collections.sort(results);
        return results;
    }

    private List<String> suggestOptionValue(Option option, String partialValue) {
        List<String> results;
        if (Strings.isNullOrEmpty(partialValue)) {
            results = this.completable.suggestOption(option.getName(), null);
        } else {
            results = this.completable.suggestOption(option.getName(), partialValue);
            if (results == null) {
                results = CliCompletor.filterList(this.completable.suggestOption(option.getName(), null), partialValue);
            }
        }
        if (results == null) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList<String>(results);
            Collections.sort(results);
        }
        return results;
    }
}

