/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmxtermExecutor {
    private static final Logger log = LogManager.getLogger(JmxtermExecutor.class);
    private static final String JAVA_JMXTERM_COMMAND = "java -jar " + System.getProperty("app.home") + "/bin/jmxterm-cli.jar";

    public static int getAttributeValue(String type, String pid, String attribute) {
        String output = JmxtermExecutor.executeJmxTermAndRetrieveLastLine("echo \"get -s -b org.apache.synapse:Name=" + type + ",Type=PassThroughConnections " + attribute + "\" | " + JAVA_JMXTERM_COMMAND + " -n -l " + pid + " | tail -1");
        return JmxtermExecutor.getInt(output);
    }

    public static String getMessageSizes(String type, String pid, String attribute) {
        String[] output = JmxtermExecutor.executeJmxTermAndRetrieveLastNLines("echo \"get -s -b org.apache.synapse:Name=" + type + ",Type=PassThroughConnections " + attribute + "\" | " + JAVA_JMXTERM_COMMAND + " -n -l " + pid + " | tail -8", 8);
        StringBuilder outputString = new StringBuilder();
        for (String line : output) {
            outputString.append(line).append("\n");
        }
        return outputString.toString();
    }

    public static int getCpuUsage(String pid) {
        String output = JmxtermExecutor.executeJmxTermAndRetrieveLastLine("echo \"get -s -b java.lang:type=OperatingSystem ProcessCpuLoad\" | " + JAVA_JMXTERM_COMMAND + " -n -l " + pid + " | tail -1");
        return JmxtermExecutor.getFloat(output).floatValue() == -1.0f ? -1 : (int)(JmxtermExecutor.getFloat(output).floatValue() * 100.0f);
    }

    public static int getMemoryUsage(String pid) {
        String output = JmxtermExecutor.executeJmxTermAndRetrieveMaxAndUsed("echo \"get -s -b java.lang:type=Memory HeapMemoryUsage\" | " + JAVA_JMXTERM_COMMAND + " -n -l " + pid + " | tail -6");
        return JmxtermExecutor.getInt(output);
    }

    private static int getInt(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return -1;
        }
        return Integer.parseInt(output);
    }

    private static Float getFloat(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return Float.valueOf(-1.0f);
        }
        return Float.valueOf(Float.parseFloat(output));
    }

    private static BufferedReader executeJmxTermCommand(String command) {
        String[] commands = new String[]{"/bin/sh", "-c", command};
        try {
            Process process = Runtime.getRuntime().exec(commands);
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            return reader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String executeJmxTermAndRetrieveMaxAndUsed(String command) {
        long max = 0L;
        long used = 0L;
        BufferedReader reader = JmxtermExecutor.executeJmxTermCommand(command);
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("max")) {
                        max = Long.parseLong(line.split("=")[1].trim().replace(";", ""));
                        continue;
                    }
                    if (!line.contains("used")) continue;
                    used = Long.parseLong(line.split("=")[1].trim().replace(";", ""));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (max == 0L) {
            return "";
        }
        return String.valueOf(used * 100L / max);
    }

    private static String executeJmxTermAndRetrieveLastLine(String command) {
        String lastLine = "";
        BufferedReader reader = JmxtermExecutor.executeJmxTermCommand(command);
        if (reader != null) {
            try {
                lastLine = JmxtermExecutor.readLastLine(reader);
            }
            catch (Exception e) {
                log.error("Error while reading last line from JMXTerm output", (Throwable)e);
                return "";
            }
        }
        return lastLine;
    }

    private static String[] executeJmxTermAndRetrieveLastNLines(String command, int numberOfLines) {
        BufferedReader reader = JmxtermExecutor.executeJmxTermCommand(command);
        if (reader != null) {
            try {
                return JmxtermExecutor.readLastNLines(reader, numberOfLines);
            }
            catch (Exception e) {
                log.error("Error while reading last " + numberOfLines + " lines from JMXTerm output", (Throwable)e);
                return new String[0];
            }
        }
        return new String[0];
    }

    private static String[] readLastNLines(BufferedReader reader, int numberOfLines) throws Exception {
        String line;
        ArrayDeque<String> lines = new ArrayDeque<String>();
        while ((line = reader.readLine()) != null) {
            lines.addLast(line);
            if (lines.size() <= numberOfLines) continue;
            lines.removeFirst();
        }
        return lines.toArray(new String[0]);
    }

    private static String readLastLine(BufferedReader reader) throws Exception {
        String line;
        String lastLine = "";
        while ((line = reader.readLine()) != null) {
            lastLine = line;
        }
        return lastLine;
    }
}

