/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers.trafficanalyzer;

import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.utils.ConfigMapHolder;
import org.wso2.diagnostics.utils.JmxtermExecutor;
import org.wso2.diagnostics.watchers.trafficanalyzer.SimpleMovingAverage;

public class TrafficAnalyzer
implements Runnable {
    private static final Logger log = LogManager.getLogger(TrafficAnalyzer.class);
    private final SimpleMovingAverage movingAverage;
    int httpListenerValue = 0;
    int httpSenderValue = 0;
    int httpsListenerValue = 0;
    int httpsSenderValue = 0;
    String pid;
    String attribute;
    int delay;
    int delayCounter;
    private static Instant lastNotification;

    public TrafficAnalyzer(String pid, int windowSize, int delay, String attribute) {
        this.attribute = attribute;
        this.pid = pid;
        this.movingAverage = new SimpleMovingAverage(windowSize);
        this.delay = delay;
        this.delayCounter = 0;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Traffic analyzer thread executing for pid: " + this.pid + ", attribute: " + this.attribute + ", delay: " + this.delay + ", delay counter: " + this.delayCounter + ", last notification: " + lastNotification);
        }
        int newHttpListenerAttributeValue = JmxtermExecutor.getAttributeValue("http-listener", this.pid, this.attribute);
        this.needToAlert(this.httpListenerValue, newHttpListenerAttributeValue, "http-listener");
        this.httpListenerValue = newHttpListenerAttributeValue;
        int newHttpsListenerAttributeValue = JmxtermExecutor.getAttributeValue("https-listener", this.pid, this.attribute);
        this.needToAlert(this.httpsListenerValue, newHttpsListenerAttributeValue, "https-listener");
        this.httpsListenerValue = newHttpsListenerAttributeValue;
        int newHttpSenderAttributeValue = JmxtermExecutor.getAttributeValue("http-sender", this.pid, this.attribute);
        this.needToAlert(this.httpSenderValue, newHttpSenderAttributeValue, "http-sender");
        this.httpSenderValue = newHttpSenderAttributeValue;
        int newHttpsSenderAttributeValue = JmxtermExecutor.getAttributeValue("https-sender", this.pid, this.attribute);
        this.needToAlert(this.httpsSenderValue, newHttpsSenderAttributeValue, "https-sender");
        this.httpsSenderValue = newHttpsSenderAttributeValue;
    }

    private void needToAlert(int oldValue, int newValue, String type) {
        Duration duration;
        if (log.isDebugEnabled()) {
            log.debug("Checking if need to alert for attribute: " + this.attribute + ", type: " + type + ", current Threshold: " + this.movingAverage.getCurrentThreshold() + ", new value: " + newValue);
        }
        boolean doNotify = true;
        int notifyInterval = Integer.parseInt((String)ConfigMapHolder.getInstance().getConfigMap().get("traffic_analyzer.notify_interval"));
        if (lastNotification != null && (duration = Duration.between(lastNotification, Instant.now())).getSeconds() < (long)notifyInterval) {
            doNotify = false;
        }
        if (this.detectAnomalies(newValue).booleanValue() && doNotify) {
            lastNotification = Instant.now();
            log.info("Attribute " + this.attribute + " of type " + type + " increased more than the threshold, old value: " + oldValue + ", new value: " + newValue + ", threshold: " + this.movingAverage.getCurrentThreshold());
        }
    }

    public void update(int newDataPoint) {
        this.movingAverage.update(newDataPoint);
    }

    public Double getThreshold() {
        return this.movingAverage.getCurrentThreshold();
    }

    public Boolean detectAnomalies(int newData) {
        if (newData <= 0) {
            return Boolean.FALSE;
        }
        this.update(newData);
        Double threshold = this.getThreshold();
        boolean isAnomaly = (double)newData > threshold;
        if (isAnomaly & this.delayCounter == 0) {
            this.delayCounter = this.delay;
            return Boolean.TRUE;
        }
        if (this.delayCounter != 0) {
            --this.delayCounter;
        }
        return Boolean.FALSE;
    }
}

