/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ServerProcess;

public class MemoryDumper
implements ActionExecutor {
    private static final Logger log = LogManager.getLogger(MemoryDumper.class);
    private final String serverProcess = ServerProcess.getProcessId();

    @Override
    public void execute(String filepath) {
        if (new File(filepath).exists()) {
            String filename = "/heap-dump.hprof ";
            String prefix = System.getenv("JAVA_HOME") + "/bin/jmap -dump:live,format=b,file=";
            String frame = prefix + filepath + filename + this.serverProcess;
            try {
                Runtime.getRuntime().exec(frame);
                Thread.sleep(1000L);
                log.info("Memory dump execution is completed for " + this.serverProcess);
            }
            catch (IOException | InterruptedException e) {
                log.error("Unable to do Memory dump for " + this.serverProcess, (Throwable)e);
            }
        }
    }

    public void execute() {
        String folderPath = System.getProperty("app.home") + File.separator + "temp" + File.separator;
        File logFolder = new File(folderPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
        this.execute(folderPath);
    }
}

