/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.utils;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JMXDataRetriever {
    private static final Logger log = LogManager.getLogger(JMXDataRetriever.class);

    public static String getAttributeValue(String type, String pid, String attribute) {
        return JMXDataRetriever.getJmxData(pid, attribute, "org.apache.synapse:Name=" + type + ",Type=PassThroughConnections");
    }

    public static int getIntAttributeValue(String type, String pid, String attribute) {
        return JMXDataRetriever.getInt(JMXDataRetriever.getJmxData(pid, attribute, "org.apache.synapse:Name=" + type + ",Type=PassThroughConnections"));
    }

    public static int getCpuUsage(String pid) {
        String output = JMXDataRetriever.getJmxData(pid, "ProcessCpuLoad", "java.lang:type=OperatingSystem");
        return JMXDataRetriever.getFloat(output).floatValue() == -1.0f ? -1 : (int)(JMXDataRetriever.getFloat(output).floatValue() * 100.0f);
    }

    public static int getMemoryUsage(String pid) {
        String output = JMXDataRetriever.getJmxData(pid, "HeapMemoryUsage", "java.lang:type=Memory");
        long usedValue = JMXDataRetriever.extractLongValue(output, "used");
        long maxValue = JMXDataRetriever.extractLongValue(output, "max");
        return JMXDataRetriever.getInt(String.valueOf(usedValue * 100L / maxValue));
    }

    private static int getInt(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return -1;
        }
        return Integer.parseInt(output);
    }

    private static Float getFloat(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return Float.valueOf(-1.0f);
        }
        return Float.valueOf(Float.parseFloat(output));
    }

    public static long extractLongValue(String input, String fieldName) {
        String regex = fieldName + "=(\\d+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJmxData(String pid, String attribute, String objectName) {
        try {
            ObjectName jmxObject = new ObjectName(objectName);
            VirtualMachineDescriptor vmDescriptor = JMXDataRetriever.findVirtualMachineDescriptor(pid);
            if (vmDescriptor == null) return "";
            VirtualMachine vm = VirtualMachine.attach(vmDescriptor);
            try {
                String connectorAddress = vm.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                if (connectorAddress == null) return "";
                JMXServiceURL jmxServiceURL = new JMXServiceURL(connectorAddress);
                JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL);
                MBeanServerConnection connection = jmxConnector.getMBeanServerConnection();
                Object attributeObj = connection.getAttribute(jmxObject, attribute);
                String string = attributeObj.toString();
                return string;
            }
            finally {
                vm.detach();
            }
        }
        catch (Exception e) {
            log.error("Error while getting JMX data", (Throwable)e);
        }
        return "";
    }

    private static VirtualMachineDescriptor findVirtualMachineDescriptor(String pid) {
        List<VirtualMachineDescriptor> vmDescriptors = VirtualMachine.list();
        for (VirtualMachineDescriptor vmDescriptor : vmDescriptors) {
            if (!vmDescriptor.id().equals(pid)) continue;
            return vmDescriptor;
        }
        return null;
    }
}

