/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ServerProcess;
import org.wso2.diagnostics.utils.ConfigMapHolder;

public class ThreadDumper
implements ActionExecutor {
    private static final Logger log = LogManager.getLogger(ThreadDumper.class);
    private final String pID = ServerProcess.getProcessId();
    private long delay;
    private int threadDumpCount;

    public ThreadDumper() {
        Map<String, Object> configuration = ConfigMapHolder.getInstance().getConfigMap();
        ArrayList actionExecutorConfigs = (ArrayList)configuration.get("action_executor_configuration");
        for (Object actionExecutorConfig : actionExecutorConfigs) {
            Map actionExecutorConfigMap = (Map)actionExecutorConfig;
            if (!actionExecutorConfigMap.get("executor").equals("ThreadDumper")) continue;
            this.threadDumpCount = Integer.parseInt(actionExecutorConfigMap.get("count").toString());
            this.delay = Integer.parseInt(actionExecutorConfigMap.get("delay").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String folderPath) {
        if (new File(folderPath).exists()) {
            String commandFrame = System.getenv("JAVA_HOME") + "/bin/jstack " + this.pID;
            for (int counter = 1; counter <= this.threadDumpCount; ++counter) {
                try {
                    String currentTimeStamp = String.valueOf(System.currentTimeMillis());
                    String filepath = folderPath + "/threaddump-" + counter + "-" + currentTimeStamp + ".txt";
                    Process process = Runtime.getRuntime().exec(commandFrame);
                    Scanner scanner = new Scanner(process.getInputStream());
                    scanner.useDelimiter("\\A");
                    try {
                        FileWriter writer = new FileWriter(filepath);
                        writer.write(scanner.next());
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error("Unable to do write in file while thread dumping");
                    }
                    scanner.close();
                    ThreadDumper threadDumper = this;
                    synchronized (threadDumper) {
                        this.wait(this.delay);
                        continue;
                    }
                }
                catch (IOException e) {
                    log.error("Unable to do thread dump for " + this.pID + "\n");
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("Unable to do wait delay time due to : " + e.getMessage());
                }
            }
        }
        log.info("Thread dump execution is completed for " + this.pID + ", thread dump count: " + this.threadDumpCount + ", delay: " + this.delay + "ms");
    }

    public void execute() {
        String folderPath = System.getProperty("app.home") + "/temp/";
        File logFolder = new File(folderPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
        this.execute(folderPath);
    }
}

