/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.utils;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JMXDataRetriever {
    private static final Logger log = LogManager.getLogger(JMXDataRetriever.class);
    private static volatile MBeanServerConnection mBeanServerConnection;

    public static String getAttributeValue(String type, String pid, String attribute) {
        return JMXDataRetriever.getJmxData(pid, attribute, "org.apache.synapse:Name=" + type + ",Type=PassThroughConnections");
    }

    public static int getIntAttributeValue(String type, String pid, String attribute) {
        return JMXDataRetriever.getInt(JMXDataRetriever.getJmxData(pid, attribute, "org.apache.synapse:Name=" + type + ",Type=PassThroughConnections"));
    }

    public static int getCpuUsage(String pid) {
        String output = JMXDataRetriever.getJmxData(pid, "ProcessCpuLoad", "java.lang:type=OperatingSystem");
        return JMXDataRetriever.getFloat(output).floatValue() == -1.0f ? -1 : (int)(JMXDataRetriever.getFloat(output).floatValue() * 100.0f);
    }

    public static int getMemoryUsage(String pid) {
        String output = JMXDataRetriever.getJmxData(pid, "HeapMemoryUsage", "java.lang:type=Memory");
        long usedValue = JMXDataRetriever.extractLongValue(output, "used");
        long maxValue = JMXDataRetriever.extractLongValue(output, "max");
        return JMXDataRetriever.getInt(String.valueOf(usedValue * 100L / maxValue));
    }

    private static int getInt(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return -1;
        }
        return Integer.parseInt(output);
    }

    private static Float getFloat(String output) {
        if (StringUtils.isEmpty((CharSequence)output)) {
            return Float.valueOf(-1.0f);
        }
        return Float.valueOf(Float.parseFloat(output));
    }

    public static long extractLongValue(String input, String fieldName) {
        String regex = fieldName + "=(\\d+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        return -1L;
    }

    public static String getJmxData(String pid, String attribute, String objectName) {
        try {
            MBeanServerConnection connection = JMXDataRetriever.getConnection(pid);
            if (connection != null) {
                ObjectName mbeanName = new ObjectName(objectName);
                return connection.getAttribute(mbeanName, attribute).toString();
            }
        }
        catch (InstanceNotFoundException e) {
            log.error("Error while getting JMX data, " + e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while getting JMX data", (Throwable)e);
            mBeanServerConnection = null;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MBeanServerConnection getConnection(String pid) {
        if (mBeanServerConnection != null) return mBeanServerConnection;
        Class<JMXDataRetriever> clazz = JMXDataRetriever.class;
        synchronized (JMXDataRetriever.class) {
            if (mBeanServerConnection != null) return mBeanServerConnection;
            log.debug("Creating JMX connection to the process with PID: " + pid);
            try {
                VirtualMachineDescriptor vmDescriptor = JMXDataRetriever.findVirtualMachineDescriptor(pid);
                if (vmDescriptor == null) return mBeanServerConnection;
                VirtualMachine vm = VirtualMachine.attach(vmDescriptor);
                try {
                    String connectorAddress = vm.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                    if (connectorAddress == null) return mBeanServerConnection;
                    JMXServiceURL jmxServiceURL = new JMXServiceURL(connectorAddress);
                    JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL);
                    mBeanServerConnection = jmxConnector.getMBeanServerConnection();
                }
                finally {
                    vm.detach();
                }
            }
            catch (Exception e) {
                log.error("Error while getting JMX data", (Throwable)e);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mBeanServerConnection;
        }
    }

    private static VirtualMachineDescriptor findVirtualMachineDescriptor(String pid) {
        List<VirtualMachineDescriptor> vmDescriptors = VirtualMachine.list();
        for (VirtualMachineDescriptor vmDescriptor : vmDescriptors) {
            if (!vmDescriptor.id().equals(pid)) continue;
            return vmDescriptor;
        }
        return null;
    }
}

