/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ActionExecutorFactory;
import org.wso2.diagnostics.postexecutor.ZipFileExecutor;
import org.wso2.diagnostics.utils.CommonUtils;
import org.wso2.diagnostics.utils.FileUtils;
import org.wso2.diagnostics.utils.JMXDataRetriever;

public class CPUWatcher
extends Thread {
    private static final Logger log = LogManager.getLogger(CPUWatcher.class);
    private final int retryCount;
    private final int threshold;
    private int count = 0;
    private final String pid;
    private long lastCountUpdatedTime;

    public CPUWatcher(String pid, int threshold, int retryCount) {
        this.pid = pid;
        this.threshold = threshold;
        this.retryCount = retryCount;
        this.lastCountUpdatedTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("CPU watcher thread executing for pid: " + this.pid + ", threshold: " + this.threshold + ", retry count: " + this.retryCount + ", count: " + this.count + ", last count updated time: " + this.lastCountUpdatedTime + ", current time: " + System.currentTimeMillis());
        }
        int cpuUsage = JMXDataRetriever.getCpuUsage(this.pid);
        log.debug("CPU usage: " + cpuUsage + "%");
        if (cpuUsage > this.threshold) {
            log.info("CPU usage is above threshold. CPU usage: " + cpuUsage + "%, Retry count: " + this.count);
            ++this.count;
            this.lastCountUpdatedTime = System.currentTimeMillis();
        }
        if (this.count > this.retryCount) {
            log.debug("CPU usage is consistently above threshold. Executing CPU watcher actions.");
            String tempFolderPath = FileUtils.createTimeStampFolder();
            String[] actionExecutors = CommonUtils.getActionExecutors("cpu_watcher");
            if (actionExecutors != null) {
                for (String actionExecutor : actionExecutors) {
                    ActionExecutor executor;
                    if (log.isDebugEnabled()) {
                        log.debug("Executing action executor: " + actionExecutor);
                    }
                    if ((executor = ActionExecutorFactory.getActionExecutor(actionExecutor)) != null) {
                        executor.execute(tempFolderPath);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Action executor " + actionExecutor + " executed successfully.");
                        continue;
                    }
                    log.error("Action executor " + actionExecutor + " is not available.");
                }
            }
            ZipFileExecutor zipFileExecutor = new ZipFileExecutor();
            zipFileExecutor.execute(tempFolderPath);
            if (log.isDebugEnabled()) {
                log.debug("Zipping the folder " + tempFolderPath + " is successful.");
            }
            FileUtils.deleteFolder(tempFolderPath);
            if (log.isDebugEnabled()) {
                log.debug("Deleted the folder " + tempFolderPath + " successfully.");
            }
            this.count = 0;
            this.lastCountUpdatedTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastCountUpdatedTime > 3600000L) {
            if (log.isDebugEnabled()) {
                log.debug("Resetting the CPU Watcher count after 1 hour.");
            }
            this.count = 0;
        }
    }
}

