/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers.trafficanalyzer;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleMovingAverage {
    private final Logger log = LogManager.getLogger(SimpleMovingAverage.class);
    private final int windowSize;
    private double ma;
    private double currentThreshold;
    private final List<Integer> tempList;

    public SimpleMovingAverage(int windowSize) {
        this.windowSize = windowSize;
        this.ma = Double.NaN;
        this.currentThreshold = Double.NaN;
        this.tempList = new ArrayList<Integer>();
    }

    public double update(int newDataPoint) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating Simple Moving Average with new data point: " + newDataPoint);
        }
        this.addDataToList(newDataPoint);
        List<Integer> tempList = this.getTempList();
        Double ma = this.findAverage(tempList);
        this.setMa(ma);
        return ma;
    }

    private double findAverage(List<Integer> list) {
        int sum = 0;
        for (int i : list) {
            sum += i;
        }
        double average = (double)sum / (double)list.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Simple Moving Average: " + average);
        }
        return average;
    }

    public void addDataToList(int newData) {
        this.updateThresholdStd();
        if (this.tempList.size() < this.windowSize) {
            this.tempList.add(newData);
        } else {
            this.tempList.remove(0);
            this.tempList.add(newData);
        }
    }

    private void updateThresholdStd() {
        double sumSquaredDiff = 0.0;
        double k = 2.0;
        for (int value : this.tempList) {
            double diff = (double)value - this.ma;
            sumSquaredDiff += diff * diff;
        }
        double std = Math.sqrt(sumSquaredDiff / (double)this.tempList.size());
        this.currentThreshold = this.ma + k * std;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating Moving Average Threshold: " + this.currentThreshold);
        }
    }

    public List<Integer> getTempList() {
        return this.tempList;
    }

    public void setMa(double ma) {
        this.ma = ma;
    }

    public double getCurrentThreshold() {
        return this.currentThreshold;
    }
}

