/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;

@Cli(name="info", description="Display detail information about an MBean", note="If -b option is not specified, current selected MBean is applied")
public class InfoCommand
extends Command {
    private static final Comparator<MBeanFeatureInfo> INFO_COMPARATOR = new Comparator<MBeanFeatureInfo>(){

        @Override
        public int compare(MBeanFeatureInfo o1, MBeanFeatureInfo o2) {
            return new CompareToBuilder().append(o1.getName(), o2.getName()).append(o1.hashCode(), o2.hashCode()).toComparison();
        }
    };
    private static final String TEXT_ATTRIBUTES = "# attributes";
    private static final String TEXT_NOTIFICATIONS = "# notifications";
    private static final String TEXT_OPERATIONS = "# operations";
    private String bean;
    private String domain;
    private boolean showDescription;
    private String type = "aon";
    private String operation;

    private void displayAttributes(MBeanInfo info) {
        Session session = this.getSession();
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        if (attrInfos.length == 0) {
            session.output.printMessage("there is no attribute");
            return;
        }
        int index = 0;
        session.output.println(TEXT_ATTRIBUTES);
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>(Arrays.asList(attrInfos));
        Collections.sort(infos, INFO_COMPARATOR);
        for (MBeanAttributeInfo attr : infos) {
            String rw = "" + (attr.isReadable() ? "r" : "") + (attr.isWritable() ? "w" : "");
            session.output.println(String.format("  %%%-3d - %s (%s, %s)" + (this.showDescription ? ", %s" : ""), index++, attr.getName(), attr.getType(), rw, attr.getDescription()));
        }
    }

    private void displayNotifications(MBeanInfo info) {
        Session session = this.getSession();
        MBeanNotificationInfo[] notificationInfos = info.getNotifications();
        if (notificationInfos.length == 0) {
            session.output.printMessage("there's no notifications");
            return;
        }
        int index = 0;
        session.output.println(TEXT_NOTIFICATIONS);
        for (MBeanNotificationInfo notification : notificationInfos) {
            session.output.println(String.format("  %%%-3d - %s(%s)" + (this.showDescription ? ", %s" : ""), index++, notification.getName(), StringUtils.join((Object[])notification.getNotifTypes(), ","), notification.getDescription()));
        }
    }

    private void displayOperations(MBeanInfo info) {
        Session session = this.getSession();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (operationInfos.length == 0) {
            session.output.printMessage("there's no operations");
            return;
        }
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>(Arrays.asList(operationInfos));
        Collections.sort(operations, INFO_COMPARATOR);
        session.output.println(TEXT_OPERATIONS);
        int index = 0;
        for (MBeanOperationInfo op : operations) {
            MBeanParameterInfo[] paramInfos = op.getSignature();
            ArrayList<String> paramTypes = new ArrayList<String>(paramInfos.length);
            ArrayList<String> paramDescriptions = new ArrayList<String>(paramInfos.length);
            for (MBeanParameterInfo paramInfo : paramInfos) {
                paramTypes.add(paramInfo.getType() + " " + paramInfo.getName());
                paramDescriptions.add("       " + paramInfo.getName() + ": " + paramInfo.getDescription());
            }
            String parameters = StringUtils.join(paramTypes, ',');
            String parametersDesc = paramDescriptions.isEmpty() ? "" : '\n' + StringUtils.join(paramDescriptions, '\n');
            session.output.println(String.format("  %%%-3d - %s %s(%s)" + (this.showDescription ? ", %s%s" : ""), index++, op.getReturnType(), op.getName(), parameters, op.getDescription(), parametersDesc));
        }
    }

    private void displaySingleOperation(MBeanInfo info) {
        Session session = this.getSession();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (operationInfos.length == 0) {
            session.output.printMessage("there's no operations");
            return;
        }
        session.output.println(TEXT_OPERATIONS);
        int index = 0;
        boolean found = false;
        for (MBeanOperationInfo op : operationInfos) {
            String opName = op.getName();
            if (!StringUtils.equals(opName, this.operation)) continue;
            found = true;
            MBeanParameterInfo[] paramInfos = op.getSignature();
            ArrayList<String> paramTypes = new ArrayList<String>(paramInfos.length);
            StringBuilder paramsDesc = new StringBuilder("             parameters:" + System.lineSeparator());
            for (MBeanParameterInfo paramInfo : paramInfos) {
                String parameter = paramInfo.getName();
                paramsDesc.append(String.format("                 + %-20s : %s" + System.lineSeparator(), parameter, paramInfo.getDescription()));
                paramTypes.add(paramInfo.getType() + " " + parameter);
            }
            session.output.println(String.format("  %%%-3d - %s %s(%s), %s", index++, op.getReturnType(), opName, StringUtils.join(paramTypes, ','), op.getDescription()));
            session.output.println(paramsDesc.toString());
        }
        if (!found) {
            session.output.printMessage(String.format("The operation '%s' is not found in the bean.", this.operation));
        }
    }

    @Override
    public void execute() throws IOException, JMException {
        Session session = this.getSession();
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        if (beanName == null) {
            throw new IllegalArgumentException("Please specify a bean using either -b option or bean command");
        }
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        MBeanInfo info = con.getMBeanInfo(name);
        session.output.printMessage("mbean = " + beanName);
        session.output.printMessage("class name = " + info.getClassName());
        if (this.showDescription) {
            session.output.printMessage("description: " + info.getDescription());
        }
        if (this.operation == null) {
            block5: for (char t : this.type.toCharArray()) {
                switch (t) {
                    case 'a': {
                        this.displayAttributes(info);
                        continue block5;
                    }
                    case 'o': {
                        this.displayOperations(info);
                        continue block5;
                    }
                    case 'n': {
                        this.displayNotifications(info);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognizable character " + t + " in type option " + this.type);
                    }
                }
            }
        } else {
            session.output.printMessage("operation = " + this.operation);
            this.displaySingleOperation(info);
        }
    }

    @Option(name="b", longName="bean", description="Name of MBean")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain for bean")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Option(name="e", longName="detail", description="Show description")
    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Option(name="t", longName="type", description="Types(a|o|u) to display, for example aon for all attributes, operations and notifications")
    public void setType(String type) {
        Validate.isTrue(StringUtils.isNotEmpty(type), "Type can't be NULL", new Object[0]);
        Validate.isTrue(Pattern.matches("^a?o?n?$", type), "Type must be a?|o?|n?", new Object[0]);
        this.type = type;
    }

    @Option(name="o", longName="op", description="Show a single operation with more details (including parameters information)")
    public void setOperation(String operation) {
        Validate.isTrue(StringUtils.isNotEmpty(operation), "Operation can't be NULL", new Object[0]);
        this.operation = operation;
    }
}

