/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ActionExecutorFactory;
import org.wso2.diagnostics.actionexecutor.ServerInfo;
import org.wso2.diagnostics.actionexecutor.ServerProcess;
import org.wso2.diagnostics.utils.ConfigMapHolder;
import org.wso2.diagnostics.utils.TomlParser;
import org.wso2.diagnostics.watchers.CPUWatcher;
import org.wso2.diagnostics.watchers.MemoryWatcher;
import org.wso2.diagnostics.watchers.Watcher;
import org.wso2.diagnostics.watchers.logwatcher.Interpreter;
import org.wso2.diagnostics.watchers.logwatcher.LogWatcher;

public class DiagnosticsApp {
    private static final Logger log = LogManager.getLogger(DiagnosticsApp.class);

    public static void main(String[] args) {
        try {
            boolean memoryWatcherEnabled;
            boolean cpuWatcherEnabled;
            boolean logWatcherEnabled;
            Thread.sleep(30000L);
            HashMap<String, ActionExecutor> actionExecutorMap = new HashMap<String, ActionExecutor>();
            LinkedHashMap<String, String[]> regexMap = new LinkedHashMap<String, String[]>();
            HashMap<String, Integer> regexPatternReloadTime = new HashMap<String, Integer>();
            Map<String, Object> configMap = DiagnosticsApp.readConfiguration(System.getProperty("app.home") + "/conf/config.toml", actionExecutorMap, regexMap, regexPatternReloadTime);
            DiagnosticsApp.printServerInfo();
            if (configMap.get("server_configuration.diagnostic_tool_enabled") == null || !Boolean.parseBoolean(configMap.get("server_configuration.diagnostic_tool_enabled").toString())) {
                log.info("Diagnostics tool is disabled. Hence exiting.");
                return;
            }
            Object appHome = System.getProperty("app.home");
            if (!((String)appHome).endsWith(File.separator)) {
                appHome = (String)appHome + File.separator;
            }
            if (logWatcherEnabled = Boolean.parseBoolean(configMap.get("log_watcher.enabled").toString())) {
                double logWatcherInterval = Double.parseDouble(configMap.get("log_watcher.interval").toString());
                LogWatcher carbonLogTailor = new LogWatcher((String)appHome + configMap.get("server_configuration.carbon_log_file_path"), new Interpreter(actionExecutorMap, regexMap, regexPatternReloadTime), logWatcherInterval);
                log.info("Listening to : " + configMap.get("server_configuration.carbon_log_file_path"));
                carbonLogTailor.start();
            }
            if (cpuWatcherEnabled = Boolean.parseBoolean(configMap.get("cpu_watcher.enabled").toString())) {
                int cpuWatcherInterval = Integer.parseInt(configMap.get("cpu_watcher.interval").toString());
                int cpuWatcherRetryCount = Integer.parseInt(configMap.get("cpu_watcher.attempts").toString());
                int cpuWatcherThreshold = Integer.parseInt(configMap.get("cpu_watcher.threshold").toString());
                log.info("Initiating CPUWatcher with interval: " + cpuWatcherInterval + " retry count: " + cpuWatcherRetryCount + " threshold: " + cpuWatcherThreshold);
                ScheduledExecutorService cpuUsageExecutorService = Executors.newSingleThreadScheduledExecutor();
                CPUWatcher cpuWatcher = new CPUWatcher(ServerProcess.getProcessId(), cpuWatcherThreshold, cpuWatcherRetryCount);
                cpuUsageExecutorService.scheduleAtFixedRate(cpuWatcher, 60L, cpuWatcherInterval, TimeUnit.SECONDS);
            }
            if (memoryWatcherEnabled = Boolean.parseBoolean(configMap.get("memory_watcher.enabled").toString())) {
                int memoryWatcherInterval = Integer.parseInt(configMap.get("memory_watcher.interval").toString());
                int memoryWatcherRetryCount = Integer.parseInt(configMap.get("memory_watcher.attempts").toString());
                int memoryWatcherThreshold = Integer.parseInt(configMap.get("memory_watcher.threshold").toString());
                log.info("Initiating MemoryWatcher with interval: " + memoryWatcherInterval + " retry count: " + memoryWatcherRetryCount + " threshold: " + memoryWatcherThreshold);
                ScheduledExecutorService memoryUsageExecutorService = Executors.newSingleThreadScheduledExecutor();
                MemoryWatcher memoryWatcher = new MemoryWatcher(ServerProcess.getProcessId(), memoryWatcherThreshold, memoryWatcherRetryCount);
                memoryUsageExecutorService.scheduleAtFixedRate(memoryWatcher, 60L, memoryWatcherInterval, TimeUnit.SECONDS);
            }
            DiagnosticsApp.loadCustomWatchers(configMap);
        }
        catch (IOException | InterruptedException e) {
            log.error("Error on starting Diagnostics tool", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> readConfiguration(String configFilePath, Map<String, ActionExecutor> actionExecutorMap, Map<String, String[]> regexTree, Map<String, Integer> regexPatternReloadTime) throws IOException {
        Map<String, Object> configMap = TomlParser.parse(configFilePath);
        ConfigMapHolder.getInstance().setConfigMap(configMap);
        ServerProcess.setProcessId((String)configMap.get("server_configuration.process_id_path"));
        ArrayList actionExecutorConfigs = (ArrayList)configMap.get("action_executor_configuration");
        for (Object actionExecutorConfig : actionExecutorConfigs) {
            String executorName = (String)((HashMap)actionExecutorConfig).get("executor");
            ActionExecutor actionExecutor = ActionExecutorFactory.getActionExecutor(executorName);
            if (actionExecutor == null) {
                log.error("Action executor " + executorName + " is not available.");
                continue;
            }
            actionExecutorMap.put(executorName, actionExecutor);
        }
        ArrayList regexConfigs = (ArrayList)configMap.get("log_pattern");
        for (Object regexConfig : regexConfigs) {
            String regexName = (String)((HashMap)regexConfig).get("regex");
            String executorList = (String)((HashMap)regexConfig).get("executors");
            String reloadTime = (String)((HashMap)regexConfig).get("reload_time");
            if (!StringUtils.isNotEmpty((CharSequence)executorList)) continue;
            String[] executors = executorList.split(",");
            regexTree.put(regexName, executors);
            regexPatternReloadTime.put(regexName, Integer.parseInt(reloadTime));
        }
        ServerProcess.writePID(System.getProperty("app.home"));
        return configMap;
    }

    private static void printServerInfo() {
        log.info("Starting WSO2 Diagnostics Tool");
        String serverInfo = new ServerInfo().getServerInfo();
        Arrays.stream(serverInfo.split("\\r?\\n")).forEach(arg_0 -> ((Logger)log).info(arg_0));
    }

    private static void loadCustomWatchers(Map<String, Object> configMap) {
        ArrayList customWatchers = (ArrayList)configMap.get("custom_watchers");
        for (Object customWatcher : customWatchers) {
            String watcherClass = (String)((HashMap)customWatcher).get("class");
            try {
                Class<?> watcher = Class.forName(watcherClass);
                Watcher customWatcherInstance = (Watcher)watcher.newInstance();
                customWatcherInstance.init(configMap);
                log.info("Initiated Custom Watcher: " + watcherClass);
                customWatcherInstance.start();
                log.info("Started Custom Watcher: " + watcherClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Error on loading custom watcher: " + watcherClass, (Throwable)e);
            }
        }
    }
}

